/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens.journal;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.screens.journal.FishingJournal;
import com.li64.tide.client.gui.screens.journal.ProfileComponent;
import com.li64.tide.client.gui.screens.journal.components.DepthComponent;
import com.li64.tide.client.gui.screens.journal.components.DimensionsComponent;
import com.li64.tide.client.gui.screens.journal.components.HorizontalLineComponent;
import com.li64.tide.client.gui.screens.journal.components.LocationComponent;
import com.li64.tide.client.gui.screens.journal.components.LuckComponent;
import com.li64.tide.client.gui.screens.journal.components.MoonPhaseComponent;
import com.li64.tide.client.gui.screens.journal.components.SeasonsComponent;
import com.li64.tide.client.gui.screens.journal.components.StatsComponent;
import com.li64.tide.client.gui.screens.journal.components.TemperatureComponent;
import com.li64.tide.client.gui.screens.journal.components.TimeComponent;
import com.li64.tide.client.gui.screens.journal.components.WeatherComponent;
import com.li64.tide.compat.seasons.SeasonsCompat;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.fishing.conditions.types.DepthRangeHolder;
import com.li64.tide.data.fishing.conditions.types.DimensionsCondition;
import com.li64.tide.data.fishing.conditions.types.LuckCondition;
import com.li64.tide.data.fishing.conditions.types.MoonPhaseCondition;
import com.li64.tide.data.fishing.conditions.types.SeasonsCondition;
import com.li64.tide.data.fishing.conditions.types.TimeOfDayCondition;
import com.li64.tide.data.fishing.conditions.types.WeatherCondition;
import com.li64.tide.data.fishing.modifiers.types.TemperatureModifier;
import com.li64.tide.data.journal.FishRarity;
import com.li64.tide.data.player.FishStats;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.util.TideUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class FishProfile
implements class_4068 {
    private static final class_2960 BORDERS = Tide.resource("textures/gui/journal/profile_borders.png");
    private static final class_2960 STAR = Tide.resource("textures/gui/journal/star.png");
    private static final int BG_WIDTH = 400;
    private static final int BG_HEIGHT = 260;
    private static final int TEXT_COLOR = 12620915;
    private final class_1799 fish;
    private final FishData data;
    private final List<ProfileComponent> profileComponents;
    private final class_327 font;
    private final class_2561 description;
    private final FishRarity rarity;
    private final class_2561 rarityPrefix;

    public FishProfile(class_1799 fish, FishingJournal journal) {
        this.font = journal.getFont();
        this.fish = fish;
        this.data = FishData.getOrThrow(fish);
        class_5250 description = class_2561.method_43471((String)this.data.profile().description().orElse("journal.description.missing"));
        if (description.getString().contains("journal.description") || description.getString().isBlank()) {
            description = class_2561.method_43471((String)"journal.description.missing");
        }
        this.description = description;
        this.rarity = this.data.profile().rarity();
        class_2583 defaultStyle = class_2561.method_43470((String)"").method_10866();
        this.rarityPrefix = class_2561.method_43471((String)"journal.rarity.title").method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)("journal.rarity." + this.rarity.getKey())).method_27696(defaultStyle.method_36139(this.rarity.getColor()))).method_27693(" (");
        this.profileComponents = FishProfile.buildComponentsWithStats(fish, this.data);
    }

    public static ArrayList<ProfileComponent> buildComponentsWithStats(class_1799 fish, FishData data) {
        ArrayList<ProfileComponent> builder = FishProfile.buildComponents(data);
        if (!builder.isEmpty() && !(builder.get(builder.size() - 1) instanceof HorizontalLineComponent)) {
            builder.add(new HorizontalLineComponent(false));
        }
        FishStats stats = TidePlayerData.CLIENT_DATA.getDataFor(fish.method_7909()).flatMap(d -> d.stats).orElse(new FishStats());
        builder.add(new StatsComponent(stats));
        return builder;
    }

    public static ArrayList<ProfileComponent> buildComponents(FishData data) {
        Optional<DimensionsCondition> dimensionCondition;
        Optional<TemperatureModifier> tempMod;
        ArrayList<ProfileComponent> builder = new ArrayList<ProfileComponent>(5);
        data.profile().location().ifPresent(location -> builder.add(new LocationComponent((class_2561)class_2561.method_43471((String)location))));
        Optional<LuckCondition> luckCondition = data.conditions().stream().filter(cond -> cond instanceof LuckCondition).findFirst().map(cond -> (LuckCondition)cond);
        luckCondition.ifPresent(condition -> builder.add(new LuckComponent(condition.getMinLuck(), condition.getMaxLuck())));
        if (!builder.isEmpty()) {
            builder.add(new HorizontalLineComponent(false));
        }
        Optional<DimensionsCondition> dimensionsCondition = data.conditions().stream().filter(cond -> cond instanceof DimensionsCondition).findFirst().map(cond -> (DimensionsCondition)cond);
        dimensionsCondition.ifPresent(condition -> {
            if (!DimensionsComponent.shouldCreate(condition)) {
                return;
            }
            builder.add(new DimensionsComponent(condition.getDimensions()));
        });
        if (SeasonsCompat.isActive()) {
            Optional<SeasonsCondition> seasonsCondition = data.conditions().stream().filter(cond -> cond instanceof SeasonsCondition).findFirst().map(cond -> (SeasonsCondition)cond);
            seasonsCondition.ifPresent(condition -> builder.add(new SeasonsComponent(condition.getSeasons())));
        }
        if ((tempMod = data.modifiers().stream().filter(mod -> mod instanceof TemperatureModifier).findFirst().map(mod -> (TemperatureModifier)mod)).isPresent()) {
            TemperatureModifier mod2 = tempMod.get();
            float minTemp = Math.max(mod2.getPreferred() - mod2.getTolerance() * 0.95f, -1.0f);
            float maxTemp = Math.max(mod2.getPreferred() + mod2.getTolerance() * 0.95f, -1.0f);
            builder.add(new TemperatureComponent(minTemp, maxTemp));
        }
        Optional<TimeOfDayCondition> timeCondition = data.conditions().stream().filter(cond -> cond instanceof TimeOfDayCondition).findFirst().map(cond -> (TimeOfDayCondition)cond);
        timeCondition.ifPresent(condition -> builder.add(new TimeComponent(condition.getRanges())));
        Optional<DepthRangeHolder> depthRange = data.conditions().stream().filter(cond -> cond instanceof DepthRangeHolder).findFirst().map(cond -> (DepthRangeHolder)((Object)cond));
        if (depthRange.isPresent() && (dimensionCondition = data.conditions().stream().filter(cond -> cond instanceof DimensionsCondition).findFirst().map(cond -> (DimensionsCondition)cond)).map(DimensionsCondition::isOverworldOnly).orElse(false).booleanValue()) {
            float max;
            DepthRangeHolder range = depthRange.get();
            float min = range.hasLowerBound() ? DepthComponent.depthToFloat(range.getMinY()) : 0.0f;
            float f = max = range.hasUpperBound() ? DepthComponent.depthToFloat(range.getMaxY()) : 1.0f;
            if (min < 0.7f || max != 1.0f) {
                builder.add(new DepthComponent(min, max));
            }
        }
        Optional<MoonPhaseCondition> moonPhaseCondition = data.conditions().stream().filter(cond -> cond instanceof MoonPhaseCondition).findFirst().map(cond -> (MoonPhaseCondition)cond);
        moonPhaseCondition.ifPresent(condition -> builder.add(new MoonPhaseComponent(condition.getPhases())));
        Optional<WeatherCondition> weatherCondition = data.conditions().stream().filter(cond -> cond instanceof WeatherCondition).findFirst().map(cond -> (WeatherCondition)cond);
        weatherCondition.ifPresent(condition -> builder.add(new WeatherComponent(condition.getWeatherTypes())));
        return builder;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int tlX = (graphics.method_51421() - 400) / 2;
        int tlY = (graphics.method_51443() - 260) / 2;
        graphics.method_25290(BORDERS, tlX, tlY, 0.0f, 0.0f, 400, 260, 400, 260);
        int titleX = tlX + 110;
        int titleY = tlY + 30;
        class_2561 title = TideUtils.removeRawTextInName(this.fish.method_7964());
        int titleWidth = this.font.method_27525((class_5348)title);
        int underlineWidth = titleWidth + 6;
        graphics.method_51439(this.font, title, titleX - titleWidth / 2, titleY, 12620915, false);
        int n = titleX - underlineWidth / 2;
        Objects.requireNonNull(this.font);
        TideUtils.blitNineSliced(graphics, FishingJournal.LINE_BOTTOM, n, titleY + 9 + 2, underlineWidth, 2, 3, 0, 71, 2, 0, 0, 71, 2);
        boolean isLarge = this.data.profile().altSprite().isPresent();
        class_2960 alternateTexture = this.data.profile().altSprite().orElse(null);
        int fishSize = isLarge ? this.data.profile().altSpriteSize().orElse(16) : 16;
        int itemCenterX = tlX + 109;
        int itemCenterY = tlY + 100;
        int shadowOffset = 2;
        float scale = 2.0f;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)itemCenterX, (float)itemCenterY, 0.0f);
        graphics.method_51448().method_22905(2.0f, 2.0f, 1.0f);
        graphics.method_51448().method_46416((float)(-itemCenterX), (float)(-itemCenterY), 0.0f);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(1.0f, 1.0f, 0.0f);
        graphics.method_51452();
        RenderSystem.setShaderColor((float)0.8431f, (float)0.7098f, (float)0.5804f, (float)1.0f);
        if (!isLarge) {
            FishingJournal.renderItemSilhouette(graphics, this.fish, itemCenterX - fishSize / 2, itemCenterY - fishSize / 2);
        } else {
            FishingJournal.renderTextureSilhouette(graphics, alternateTexture, itemCenterX - fishSize / 2, itemCenterY - fishSize / 2, fishSize, fishSize);
        }
        graphics.method_51452();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_51448().method_22909();
        if (!isLarge) {
            graphics.method_51427(this.fish, itemCenterX - fishSize / 2, itemCenterY - fishSize / 2);
        } else {
            graphics.method_25290(alternateTexture, itemCenterX - fishSize / 2, itemCenterY - fishSize / 2, 0.0f, 0.0f, fishSize, fishSize, fishSize, fishSize);
        }
        graphics.method_51448().method_22909();
        int stars = this.rarity.getNumStars();
        int rarityX = tlX + 40;
        int rarityY = tlY + 167;
        graphics.method_51439(this.font, this.rarityPrefix, rarityX, rarityY, 12620915, false);
        for (int i = 0; i < stars; ++i) {
            graphics.method_25290(STAR, rarityX + this.font.method_27525((class_5348)this.rarityPrefix) + i * 8, rarityY, 0.0f, 0.0f, 7, 6, 7, 6);
        }
        graphics.method_51433(this.font, ")", rarityX + this.font.method_27525((class_5348)this.rarityPrefix) + stars * 8, rarityY, 12620915, false);
        int descX = tlX + 38;
        int descY = tlY + 207;
        List descriptionLines = this.font.method_1728((class_5348)this.description, 156);
        int n2 = descriptionLines.size();
        Objects.requireNonNull(this.font);
        descY -= n2 * 9 / 2;
        for (int i = 0; i < descriptionLines.size(); ++i) {
            class_5481 class_54812 = (class_5481)descriptionLines.get(i);
            Objects.requireNonNull(this.font);
            graphics.method_51430(this.font, class_54812, descX, descY + i * 9, 12620915, false);
        }
        int padding = 4;
        int cursorY = padding + 8;
        for (ProfileComponent area : this.profileComponents) {
            area.render(graphics, this.font, tlX + 203, tlY + 24 + cursorY, mouseX, mouseY, partialTick);
            cursorY += area.getRequiredHeight() + padding;
        }
    }
}

