/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens.journal;

import com.li64.tide.Tide;
import com.li64.tide.client.TideCoreShaders;
import com.li64.tide.client.TideRenderTypes;
import com.li64.tide.client.gui.screens.journal.FishProfile;
import com.li64.tide.data.SendableDataMap;
import com.li64.tide.data.TideData;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.journal.JournalGroup;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ReadProfileMsg;
import com.li64.tide.registries.TideSoundEvents;
import com.li64.tide.util.TideUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6880;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class FishingJournal
extends class_437 {
    public static final int TEXT_COLOR = 12620915;
    static final class_2960 BACKGROUND = Tide.resource("textures/gui/journal/journal_bg.png");
    static final int BG_WIDTH = 400;
    static final int BG_HEIGHT = 260;
    static final class_2960 LINE_TOP = TideUtils.sprite("journal/line_top");
    static final class_2960 LINE_BOTTOM = TideUtils.sprite("journal/line_bottom");
    private static final int AREA_HEIGHT = 190;
    private static final int CELL_SIZE = 22;
    private static final int GROUP_SPACING = 10;
    private static final int FISH_PER_ROW = 14;
    private final class_1657 player;
    private final List<Map<JournalGroup, List<class_6880<class_1792>>>> fishByPage;
    private int page = 0;
    @Nullable
    private class_1799 activeFish = null;
    @Nullable
    private FishProfile profile = null;
    @Nullable
    private class_4185 xButton = null;
    @Nullable
    private class_4185 leftButton = null;
    @Nullable
    private class_4185 rightButton = null;
    private float yOffset = 3.0f;
    private boolean didClick;

    public FishingJournal(class_1657 player) {
        super(class_333.field_18967);
        this.player = player;
        this.fishByPage = FishingJournal.paginate(((SendableDataMap)TideData.FISH.get()).valueStream().filter(FishData::hasJournalEntry).sorted(Comparator.comparing(a -> a.profile().group().ordinal()).thenComparing(a -> a.profile().rarity().ordinal()).thenComparingDouble(d -> -d.weight())).collect(Collectors.groupingBy(data -> data.profile().group(), LinkedHashMap::new, Collectors.mapping(FishData::fish, Collectors.toList()))));
        this.method_25426();
        player.method_5783(TideSoundEvents.JOURNAL_OPEN, 0.9f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    public static List<Map<JournalGroup, List<class_6880<class_1792>>>> paginate(Map<JournalGroup, List<class_6880<class_1792>>> groupedFish) {
        ArrayList<Map<JournalGroup, List<class_6880<class_1792>>>> pages = new ArrayList<Map<JournalGroup, List<class_6880<class_1792>>>>();
        LinkedHashMap<JournalGroup, List> currentPage = new LinkedHashMap<JournalGroup, List>();
        int usedHeight = 0;
        for (Map.Entry<JournalGroup, List<class_6880<class_1792>>> entry : groupedFish.entrySet()) {
            JournalGroup group = entry.getKey();
            List<class_6880<class_1792>> fish = entry.getValue();
            int totalRows = (int)Math.ceil((double)fish.size() / 14.0);
            int start = 0;
            for (int row = 0; row < totalRows; ++row) {
                int end = Math.min(start + 14, fish.size());
                List<class_6880<class_1792>> rowFish = fish.subList(start, end);
                if (usedHeight + 22 > 190) {
                    pages.add(currentPage);
                    currentPage = new LinkedHashMap();
                    usedHeight = 0;
                }
                currentPage.computeIfAbsent(group, g -> new ArrayList()).addAll(rowFish);
                usedHeight += 22;
                start = end;
            }
            if (usedHeight <= 0 || usedHeight + 10 > 190) continue;
            usedHeight += 10;
        }
        if (!currentPage.isEmpty()) {
            pages.add(currentPage);
        }
        return pages;
    }

    public boolean method_25421() {
        return false;
    }

    private void pageChanged() {
        this.yOffset = 3.0f;
        this.player.method_5783(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
        this.method_25426();
    }

    protected void method_25426() {
        this.method_37067();
        this.leftButton = null;
        this.rightButton = null;
        int xX = Math.min(this.field_22789 - 19, (this.field_22789 + 400) / 2 - 27);
        int xY = Math.max(3, (this.field_22790 - 260) / 2 + 12);
        int leftX = Math.max(3, (this.field_22789 - 400) / 2 + 11);
        int rightX = Math.min(this.field_22789 - 19, (this.field_22789 + 400) / 2 - 27);
        if (this.activeFish != null) {
            this.profile = new FishProfile(this.activeFish, this);
            this.xButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), button -> {
                this.activeFish = null;
                this.pageChanged();
            }).method_46434(xX, xY, 16, 16).method_46431();
        } else {
            this.profile = null;
            this.xButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), button -> this.method_25419()).method_46434(xX, xY, 16, 16).method_46431();
            if (this.page > 0) {
                this.leftButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<<"), button -> this.pageLeft()).method_46434(leftX, this.field_22790 / 2 - 8, 16, 16).method_46431();
                this.method_25429((class_364)this.leftButton);
            }
            if (this.page < this.fishByPage.size() - 1) {
                this.rightButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)">>"), button -> this.pageRight()).method_46434(rightX, this.field_22790 / 2 - 8, 16, 16).method_46431();
                this.method_25429((class_364)this.rightButton);
            }
        }
        this.method_25429((class_364)this.xButton);
    }

    private void pageLeft() {
        --this.page;
        if (this.page < 0) {
            this.page = this.fishByPage.size() - 1;
        }
        this.pageChanged();
    }

    private void pageRight() {
        ++this.page;
        if (this.page == this.fishByPage.size()) {
            this.page = 0;
        }
        this.pageChanged();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!super.method_25402(mouseX, mouseY, button)) {
            this.didClick = true;
        }
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return switch (keyCode) {
            case 69, 256 -> {
                if (this.activeFish == null) {
                    this.method_25419();
                } else {
                    this.activeFish = null;
                    this.pageChanged();
                }
                yield true;
            }
            case 262 -> {
                if (this.activeFish == null) {
                    this.pageRight();
                }
                yield true;
            }
            case 263 -> {
                if (this.activeFish == null) {
                    this.pageLeft();
                }
                yield true;
            }
            default -> super.method_25404(keyCode, scanCode, modifiers);
        };
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25419() {
        super.method_25419();
        this.player.method_5783(TideSoundEvents.JOURNAL_CLOSE, 0.9f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        float deltaTicks = class_310.method_1551().method_1534();
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        boolean updatePage = false;
        this.yOffset = Math.max(this.yOffset - this.yOffset * 0.65f * deltaTicks, 0.0f);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, (float)(-((int)this.yOffset)), 0.0f);
        int tlX = (this.field_22789 - 400) / 2;
        int tlY = (this.field_22790 - 260) / 2;
        graphics.method_25290(BACKGROUND, tlX, tlY, 0.0f, 0.0f, 400, 260, 400, 260);
        if (this.profile != null) {
            this.profile.method_25394(graphics, mouseX, mouseY, partialTick);
        } else {
            int hoverTolerance = 3;
            int cursorY = 0;
            int groupIndex = 0;
            for (List<class_6880<class_1792>> fish : this.fishByPage.get(this.page).values()) {
                int gridX = tlX + 44;
                int gridY = tlY + 39 + cursorY;
                int i = 0;
                for (class_6880<class_1792> fishItem : fish) {
                    int cellX = i % 14;
                    int cellY = class_3532.method_15375((float)((float)i / 14.0f));
                    int x = gridX + cellX * 22;
                    int y = gridY + cellY * 22;
                    class_1799 stack = new class_1799(fishItem);
                    boolean isUnlocked = TidePlayerData.CLIENT_DATA.isFishUnlocked(fishItem);
                    boolean isUnread = TidePlayerData.CLIENT_DATA.isUnread(stack);
                    boolean isHovering = false;
                    if (mouseX > x - 3 && mouseY > y - 3 && mouseX < x + 16 + 3 && mouseY < y + 16 + 3) {
                        isHovering = true;
                        if (isUnread) {
                            TidePlayerData.CLIENT_DATA.markAsRead(stack);
                            Tide.NETWORK.sendToServer(new ReadProfileMsg(stack));
                        }
                        if (isUnlocked) {
                            graphics.method_51438(this.field_22793, stack.method_7964(), mouseX, mouseY);
                            if (this.didClick) {
                                this.activeFish = stack;
                                updatePage = true;
                            }
                        }
                    }
                    graphics.method_51452();
                    RenderSystem.setShaderColor((float)0.8431f, (float)0.7098f, (float)0.5804f, (float)1.0f);
                    FishingJournal.renderItemSilhouette(graphics, stack, x + 1, y + 1);
                    if (isHovering) {
                        graphics.method_51452();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.drawOutline(graphics, stack, x, y);
                    } else if (Tide.CONFIG.journal.showUnread && isUnlocked && isUnread) {
                        graphics.method_51452();
                        RenderSystem.enableBlend();
                        RenderSystem.setShaderColor((float)1.0f, (float)0.88f, (float)0.0f, (float)1.0f);
                        this.drawOutline(graphics, stack, x, y);
                        RenderSystem.disableBlend();
                    }
                    graphics.method_51452();
                    if (isUnlocked) {
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        graphics.method_51427(stack, x, y);
                    } else {
                        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        graphics.method_51427(stack, x, y);
                        graphics.method_51452();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    ++i;
                }
                cursorY += class_3532.method_15375((float)((float)(i - 1) / 14.0f + 1.0f)) * 22 + 10;
                if (++groupIndex >= this.fishByPage.get(this.page).size()) continue;
                TideUtils.blitNineSliced(graphics, LINE_BOTTOM, tlX + 40, tlY + 36 + cursorY - 5, 327, 2, 3, 0, 71, 2, 0, 0, 71, 2);
            }
        }
        if (this.xButton != null) {
            this.xButton.method_25394(graphics, mouseX, mouseY, partialTick);
        }
        if (this.leftButton != null) {
            this.leftButton.method_25394(graphics, mouseX, mouseY, partialTick);
        }
        if (this.rightButton != null) {
            this.rightButton.method_25394(graphics, mouseX, mouseY, partialTick);
        }
        graphics.method_51448().method_22909();
        if (updatePage) {
            this.pageChanged();
        }
        this.didClick = false;
    }

    private void drawOutline(@NotNull class_332 graphics, class_1799 stack, int x, int y) {
        int[][] offs;
        for (int[] off : offs = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}}) {
            FishingJournal.renderItemSilhouette(graphics, stack, x + off[0], y + off[1]);
        }
    }

    public static void renderTextureSilhouette(class_332 graphics, class_2960 texture, int x, int y, int w, int h) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(TideCoreShaders::fullWhite);
        Matrix4f pose = graphics.method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22918(pose, (float)x, (float)y, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22918(pose, (float)x, (float)(y + h), 0.0f).method_22913(0.0f, 1.0f).method_1344();
        builder.method_22918(pose, (float)(x + w), (float)(y + h), 0.0f).method_22913(1.0f, 1.0f).method_1344();
        builder.method_22918(pose, (float)(x + w), (float)y, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    public static void renderItemSilhouette(class_332 graphics, class_1799 stack, int x, int y) {
        class_310 minecraft = class_310.method_1551();
        class_1087 model = minecraft.method_1480().method_4019(stack, (class_1937)minecraft.field_1687, (class_1309)minecraft.field_1724, 0);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x + 8.0f, (float)y + 8.0f, 150.0f);
        graphics.method_51448().method_22905(16.0f, -16.0f, 16.0f);
        graphics.method_51448().method_22903();
        model.method_4709().method_3503(class_811.field_4317).method_23075(false, graphics.method_51448());
        graphics.method_51448().method_46416(-0.5f, -0.5f, -0.5f);
        class_1921 renderType = TideRenderTypes.singleColorItem();
        class_4588 vertexConsumer = class_918.method_23181((class_4597)graphics.method_51450(), (class_1921)renderType, (boolean)true, (boolean)stack.method_7958());
        class_310.method_1551().method_1480().method_23182(model, stack, 0xF000F0, class_4608.field_21444, graphics.method_51448(), vertexConsumer);
        graphics.method_51448().method_22909();
        graphics.method_51452();
        graphics.method_51448().method_22909();
    }
}

