/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens.journal.components;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.screens.journal.ProfileComponent;
import com.li64.tide.data.fishing.conditions.types.DimensionsCondition;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class DimensionsComponent
extends ProfileComponent {
    private static final class_2960 DIMENSIONS = Tide.resource("textures/gui/journal/dimensions.png");
    private static final class_2561 TITLE = class_2561.method_43471((String)"journal.info.dimensions.title");
    public List<class_5321<class_1937>> dimensions;

    public static boolean shouldCreate(DimensionsCondition condition) {
        if (condition.isOverworldOnly()) {
            return false;
        }
        return condition.getDimensions().stream().anyMatch(DimensionsComponent::isKnown);
    }

    public DimensionsComponent(List<class_5321<class_1937>> dimensions) {
        this.dimensions = dimensions.stream().filter(DimensionsComponent::isKnown).toList();
    }

    @Override
    public void render(@NotNull class_332 graphics, class_327 font, int x, int y, int mouseX, int mouseY, float partialTick) {
        int center = x + 87;
        graphics.method_51439(font, TITLE, center - font.method_27525((class_5348)TITLE) / 2, y, 12620915, false);
        int count = this.dimensions.size();
        int spriteY = y + 12;
        int padding = 4;
        for (int i = 0; i < count; ++i) {
            int cellSize = 10 + padding;
            int spriteX = center - (count - 1) * cellSize / 2 + i * cellSize - 4;
            int offset = DimensionsComponent.getOffset(this.dimensions.get(i));
            graphics.method_25290(DIMENSIONS, spriteX, spriteY, (float)offset, 0.0f, 10, 10, 30, 10);
            if (mouseX < spriteX || mouseX > spriteX + 10 || mouseY < spriteY || mouseY > spriteY + 10) continue;
            graphics.method_51438(font, (class_2561)class_2561.method_43471((String)("journal.info.dimensions." + this.dimensions.get(i).method_29177().method_12832())), mouseX, mouseY);
        }
    }

    public static boolean isKnown(class_5321<class_1937> dimension) {
        return DimensionsComponent.getOffset(dimension) >= 0;
    }

    public static int getOffset(class_5321<class_1937> dimension) {
        if (dimension == class_1937.field_25179) {
            return 0;
        }
        if (dimension == class_1937.field_25180) {
            return 10;
        }
        if (dimension == class_1937.field_25181) {
            return 20;
        }
        return -1;
    }

    @Override
    public int getRequiredHeight() {
        return 26;
    }
}

