/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens.journal.components;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.client.gui.screens.journal.ProfileComponent;
import com.li64.tide.data.player.CatchTimestamp;
import com.li64.tide.data.player.FishStats;
import com.li64.tide.util.TideUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class StatsComponent
extends ProfileComponent {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private final List<class_2561> lines;

    public StatsComponent(FishStats stats) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)class_2561.method_43469((String)"journal.info.stats.total", (Object[])new Object[]{stats.getAmountCaught()}));
        if (!stats.isEmpty()) {
            if (stats.getInitialCatchDate().isPresent()) {
                class_5250 formatted;
                CatchTimestamp timestamp = stats.getInitialCatchDate().get();
                if (Tide.CONFIG.journal.useRealDate) {
                    Instant instant = timestamp.date();
                    ZonedDateTime localTime = instant.atZone(ZoneId.systemDefault());
                    formatted = class_2561.method_43470((String)localTime.format(DATE_FORMAT));
                } else {
                    formatted = class_2561.method_43469((String)"journal.info.stats.day", (Object[])new Object[]{(int)(timestamp.ticks() / 24000L)});
                }
                builder.add((Object)class_2561.method_43469((String)"journal.info.stats.first", (Object[])new Object[]{formatted}));
            }
            if (stats.getLargestCatch() > 0.0) {
                builder.add((Object)class_2561.method_43469((String)"journal.info.stats.largest", (Object[])new Object[]{TideUtils.getFormattedLength(stats.getLargestCatch())}));
                builder.add((Object)class_2561.method_43469((String)"journal.info.stats.smallest", (Object[])new Object[]{TideUtils.getFormattedLength(stats.getSmallestCatch())}));
            }
        }
        this.lines = builder.build();
    }

    @Override
    public void render(@NotNull class_332 graphics, class_327 font, int x, int y, int mouseX, int mouseY, float partialTick) {
        int center = x + 87;
        int cursorY = 0;
        for (class_2561 line : this.lines) {
            graphics.method_51439(font, line, center - font.method_27525((class_5348)line) / 2, y + cursorY, 12620915, false);
            cursorY += 11;
        }
    }

    @Override
    public int getRequiredHeight() {
        return this.lines.size() * 11;
    }
}

