/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens.journal.components;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.screens.journal.ProfileComponent;
import com.li64.tide.data.fishing.conditions.types.WeatherType;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class WeatherComponent
extends ProfileComponent {
    private static final class_2960 ICONS = Tide.resource("textures/gui/journal/weather.png");
    private static final class_2561 TITLE = class_2561.method_43471((String)"journal.info.weather.title");
    public List<WeatherType> weatherTypes;

    public WeatherComponent(List<WeatherType> weatherTypes) {
        this.weatherTypes = weatherTypes;
    }

    @Override
    public void render(@NotNull class_332 graphics, class_327 font, int x, int y, int mouseX, int mouseY, float partialTick) {
        int center = x + 87;
        graphics.method_51439(font, TITLE, center - font.method_27525((class_5348)TITLE) / 2, y, 12620915, false);
        int count = this.weatherTypes.size();
        int spriteY = y + 12;
        int padding = 4;
        for (int i = 0; i < count; ++i) {
            int cellSize = 10 + padding;
            int spriteX = center - (count - 1) * cellSize / 2 + i * cellSize - 4;
            int offset = WeatherComponent.getOffset(this.weatherTypes.get(i)) * 10;
            graphics.method_25290(ICONS, spriteX, spriteY, (float)offset, 0.0f, 10, 10, 30, 10);
            if (mouseX < spriteX || mouseX > spriteX + 10 || mouseY < spriteY || mouseY > spriteY + 10) continue;
            graphics.method_51438(font, (class_2561)class_2561.method_43471((String)("journal.info.weather." + this.weatherTypes.get(i).method_15434())), mouseX, mouseY);
        }
    }

    public static int getOffset(WeatherType weatherType) {
        return switch (weatherType) {
            default -> throw new IncompatibleClassChangeError();
            case WeatherType.CLEAR -> 0;
            case WeatherType.RAIN -> 1;
            case WeatherType.STORM -> 2;
        };
    }

    @Override
    public int getRequiredHeight() {
        return 26;
    }
}

