/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.compat.stardewfishing;

import com.google.gson.JsonElement;
import com.li64.tide.Tide;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.registries.TideFish;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class StardewFishingBehaviors
implements class_2405 {
    private final class_2960 LOCATION = Tide.resource("stardew_fishing", "fish_behaviors");
    private final CompletableFuture<class_7225.class_7874> registries;
    private final class_7784.class_7489 pathProvider;

    public StardewFishingBehaviors(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
        this.pathProvider = output.method_45973(class_7784.class_7490.field_39367, "");
        this.registries = registries;
    }

    @NotNull
    public final CompletableFuture<?> method_10319(class_7403 output) {
        return this.registries.thenCompose(provider -> this.run(output, (class_7225.class_7874)provider));
    }

    private void generate(HashMap<class_2960, MockFishBehavior> output) {
        TideFish.DATA_BUILDERS.forEach((item, constructor) -> {
            FishData.Builder builder = FishData.builder();
            constructor.accept(builder.fish((class_1792)item));
            FishData data = builder.build();
            output.put(class_7923.field_41178.method_10221(item), MockFishBehavior.fromFishData(data));
        });
    }

    public CompletableFuture<?> run(class_7403 output, class_7225.class_7874 registries) {
        HashMap<class_2960, MockFishBehavior> behaviors = new HashMap<class_2960, MockFishBehavior>();
        this.generate(behaviors);
        MockFishBehaviorList list = new MockFishBehaviorList(false, behaviors, Optional.empty());
        return class_2405.method_10320((class_7403)output, (JsonElement)((JsonElement)MockFishBehaviorList.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)list).resultOrPartial(arg_0 -> ((Logger)Tide.LOG).error(arg_0)).orElseThrow()), (Path)this.pathProvider.method_44107(this.LOCATION));
    }

    @NotNull
    public String method_10321() {
        return "Stardew Fishing Behaviors";
    }

    private record MockFishBehaviorList(boolean replace, Map<class_2960, MockFishBehavior> behaviors, Optional<MockFishBehavior> defaultBehavior) {
        public static final Codec<MockFishBehaviorList> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(MockFishBehaviorList::replace), (App)Codec.unboundedMap((Codec)class_2960.field_25139, MockFishBehavior.CODEC).fieldOf("behaviors").forGetter(MockFishBehaviorList::behaviors), (App)MockFishBehavior.CODEC.optionalFieldOf("defaultBehavior").forGetter(MockFishBehaviorList::defaultBehavior)).apply((Applicative)inst, MockFishBehaviorList::new));
    }

    private record MockFishBehavior(int idleTime, float topSpeed, float upAcceleration, float downAcceleration, int avgDistance, int moveVariation) {
        public static final Codec<MockFishBehavior> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("idle_time").forGetter(MockFishBehavior::idleTime), (App)Codec.FLOAT.fieldOf("top_speed").forGetter(MockFishBehavior::topSpeed), (App)Codec.FLOAT.fieldOf("up_acceleration").forGetter(MockFishBehavior::upAcceleration), (App)Codec.FLOAT.fieldOf("down_acceleration").forGetter(MockFishBehavior::downAcceleration), (App)Codec.INT.fieldOf("avg_distance").forGetter(MockFishBehavior::avgDistance), (App)Codec.INT.fieldOf("move_variation").forGetter(MockFishBehavior::moveVariation)).apply((Applicative)inst, MockFishBehavior::new));

        public static MockFishBehavior fromFishData(FishData data) {
            int idleTime = Math.max(Math.round(16.0f - 5.0f * data.speed()), 1);
            float topSpeed = 3.2f * data.speed();
            float upAcceleration = 0.1f + 0.3f * data.speed();
            float downAcceleration = 0.1f + 0.3f * data.speed();
            int avgDistance = Math.max(Math.round(100.0f * data.strength()), 10);
            int moveVariation = Math.round((float)Math.exp(4.5f * data.strength() - 0.8f) + 1.0f);
            return new MockFishBehavior(idleTime, topSpeed, upAcceleration, downAcceleration, avgDistance, moveVariation);
        }
    }
}

