/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data;

import com.google.common.collect.ImmutableMap;
import com.li64.tide.Tide;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SendableDataMap<T> {
    public Map<class_2960, T> data;
    public Codec<T> codec;

    public SendableDataMap(Map<class_2960, T> data, Codec<T> codec) {
        this.data = ImmutableMap.copyOf(data);
        this.codec = codec;
    }

    public T getEntry(class_2960 location) {
        return this.data.get(location);
    }

    public Optional<T> getEntryOptional(class_2960 location) {
        return Optional.ofNullable(this.getEntry(location));
    }

    public Stream<Map.Entry<class_2960, T>> stream() {
        return this.data.entrySet().parallelStream();
    }

    public Stream<T> valueStream() {
        return this.data.values().parallelStream();
    }

    public List<T> values() {
        return this.valueStream().toList();
    }

    public Set<class_2960> getKeys() {
        return this.data.keySet();
    }

    public int count() {
        return this.data.size();
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.data.size());
        this.data.keySet().forEach(arg_0 -> ((class_2540)buf).method_10812(arg_0));
        this.data.values().forEach(value -> buf.method_49395(this.codec, value));
    }

    public static <T> SendableDataMap<T> decode(class_2540 buf, Codec<T> codec) {
        int i;
        int size = buf.readInt();
        ArrayList<class_2960> keys = new ArrayList<class_2960>(size);
        ArrayList<Object> values = new ArrayList<Object>(size);
        for (i = 0; i < size; ++i) {
            keys.add(buf.method_10810());
        }
        for (i = 0; i < size; ++i) {
            values.add(buf.method_49394(codec));
        }
        HashMap map = new HashMap();
        for (int i2 = 0; i2 < size; ++i2) {
            map.put((class_2960)keys.get(i2), values.get(i2));
        }
        return new SendableDataMap(map, codec);
    }

    public static <T> SendableDataMap<T> merge(SendableDataMap<T> map, Map<class_2960, T> other) {
        HashMap<class_2960, T> merged = new HashMap<class_2960, T>(map.data);
        merged.putAll(other);
        return new SendableDataMap<T>(merged, map.codec);
    }

    public void debugLogContents(BiConsumer<class_2960, T> logger) {
        Tide.LOG.info("Logging sendable data map contents:");
        this.data.forEach(logger);
    }
}

