/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data;

import com.li64.tide.data.fishing.CrateData;
import com.li64.tide.data.fishing.FishingLootData;
import com.li64.tide.data.loaders.AbstractDataLoader;
import com.li64.tide.data.loaders.FishDataLoader;
import com.li64.tide.data.loaders.FlatDataLoader;
import com.li64.tide.data.loaders.LayeredDataLoader;
import com.li64.tide.data.rods.AccessoryData;
import com.li64.tide.data.rods.BaitData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3302;

public class TideData {
    private static final List<AbstractDataLoader<?, ?>> LOADERS = new ArrayList();
    public static FishDataLoader FISH = TideData.registerDataLoader(new FishDataLoader("fishing/fish"));
    public static LayeredDataLoader<FishingLootData> FISHING_LOOT = TideData.registerDataLoader(LayeredDataLoader.of("fishing/loot", FishingLootData.CODEC));
    public static LayeredDataLoader<CrateData> CRATES = TideData.registerDataLoader(LayeredDataLoader.of("fishing/crates", CrateData.CODEC));
    public static FlatDataLoader<BaitData> BAIT = TideData.registerDataLoader(FlatDataLoader.of("bait", BaitData.CODEC));
    public static FlatDataLoader<AccessoryData> ACCESSORIES = TideData.registerDataLoader(FlatDataLoader.of("rod_accessories", AccessoryData.CODEC));

    private static <T, R, L extends AbstractDataLoader<T, R>> L registerDataLoader(L loader) {
        LOADERS.add(loader);
        return loader;
    }

    public static void onRegisterReloadListeners(BiConsumer<class_2960, class_3302> registry) {
        LOADERS.forEach(loader -> registry.accept(loader.getDirectory(), (class_3302)loader));
    }

    public static void readFromPacket(class_2540 buf) {
        LOADERS.forEach(loader -> loader.decode(buf));
    }

    public static void writeToPacket(class_2540 buf) {
        LOADERS.forEach(loader -> loader.encode(buf));
    }
}

