/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.commands;

import com.li64.tide.Tide;
import com.li64.tide.data.commands.TestType;
import com.li64.tide.data.fishing.selector.FishingEntry;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class FishingCommand {
    public FishingCommand(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fishing").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"test").then(class_2170.method_9247((String)"loot").executes(ctx -> this.test((class_2168)ctx.getSource(), TestType.LOOT)))).then(class_2170.method_9247((String)"crate").executes(ctx -> this.test((class_2168)ctx.getSource(), TestType.CRATES)))).then(class_2170.method_9247((String)"fish").executes(ctx -> this.test((class_2168)ctx.getSource(), TestType.FISH)))));
    }

    private int test(class_2168 source, TestType type) {
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        TideFishingHook hook = HookAccessor.getHook((class_1657)player);
        if (hook == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.fishing.no_hook"));
            return 0;
        }
        Map<FishingEntry, Double> results = Tide.FISHING_MANAGER.test(hook.getContext(), type);
        if (results == null || results.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.fishing.nothing_found"));
            return 0;
        }
        double total = results.values().stream().mapToDouble(d -> d).sum();
        List<Map.Entry> sortedResults = results.entrySet().stream().sorted(Comparator.comparing(entry -> -((Double)entry.getValue()).doubleValue())).toList();
        class_5250 formattedResults = class_2561.method_43471((String)"commands.fishing.results").method_27692(class_124.field_1065);
        sortedResults.forEach(entry -> {
            formattedResults.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            formattedResults.method_10852((class_2561)((FishingEntry)entry.getKey()).getTestKey().method_27692(class_124.field_1068));
            formattedResults.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1068));
            String percent = String.format("%.1f", (Double)entry.getValue() / total * 100.0) + "%";
            formattedResults.method_10852((class_2561)class_2561.method_43470((String)percent).method_27692(class_124.field_1075));
        });
        source.method_9226(() -> formattedResults, true);
        return 1;
    }
}

