/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.commands;

import com.li64.tide.Tide;
import com.li64.tide.data.SendableDataMap;
import com.li64.tide.data.TideData;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.util.TideUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7923;

public class JournalCommand {
    public JournalCommand(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"journal").requires(stack -> stack.method_9259(2))).then(class_2170.method_9247((String)"reset").executes(ctx -> this.reset((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unlock").then(class_2170.method_9247((String)"all").executes(ctx -> this.unlockAll((class_2168)ctx.getSource())))).then(class_2170.method_9244((String)"fish", (ArgumentType)class_2287.method_9776((class_7157)buildContext)).executes(ctx -> this.unlock((class_2168)ctx.getSource(), class_2287.method_9777((CommandContext)ctx, (String)"fish").method_9785())))));
    }

    private int unlock(class_2168 source, class_1792 fishItem) {
        class_1799 fish = fishItem.method_7854();
        if (source.method_44023() == null) {
            return 0;
        }
        if (!TideUtils.isJournalFish(fish)) {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.journal.unlock.fail", (Object[])new Object[]{fish.method_7964().getString()}));
            return 0;
        }
        TidePlayerData data = TidePlayerData.getOrCreate(source.method_44023());
        boolean success = data.unlockFish((class_6880<class_1792>)class_7923.field_41178.method_47983((Object)fishItem), source.method_44023());
        if (success) {
            TideUtils.showFishToast(fish, source.method_44023());
            data.syncTo(source.method_44023());
            source.method_9226(() -> class_2561.method_43469((String)"commands.journal.unlock", (Object[])new Object[]{fish.method_7964().getString(), source.method_44023().method_5476()}), true);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43469((String)"commands.journal.unlock.already_unlocked", (Object[])new Object[]{fish.method_7954().getString()}));
        return 0;
    }

    private int unlockAll(class_2168 source) {
        if (source.method_44023() == null) {
            return 0;
        }
        TidePlayerData data = TidePlayerData.getOrCreate(source.method_44023());
        ((SendableDataMap)TideData.FISH.get()).values().forEach(fishData -> data.unlockFish(fishData.fish(), source.method_44023()));
        data.syncTo(source.method_44023());
        source.method_9226(() -> class_2561.method_43469((String)"commands.journal.unlock_all", (Object[])new Object[]{source.method_44023().method_5476()}), true);
        return 1;
    }

    private int reset(class_2168 source) {
        if (source.method_44023() == null) {
            return 0;
        }
        try {
            TidePlayerData data = new TidePlayerData();
            data.syncTo(source.method_44023());
            source.method_9226(() -> class_2561.method_43469((String)"commands.journal.lock", (Object[])new Object[]{source.method_44023().method_5476()}), true);
        }
        catch (Exception e) {
            Tide.LOG.error("Could not reset player data: ", (Throwable)e);
            return 0;
        }
        return 1;
    }
}

