/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing;

import com.li64.tide.data.fishing.CrateData;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.fishing.FishingLootData;
import com.li64.tide.data.fishing.selector.FishingEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;

public record CatchResult(List<class_1799> items, Optional<FishingEntry> entry) {
    public static CatchResult of(List<class_1799> items, FishingEntry entry) {
        return new CatchResult(items, Optional.of(entry));
    }

    public static CatchResult empty(FishingEntry entry) {
        return new CatchResult(List.of(), Optional.of(entry));
    }

    public static CatchResult empty() {
        return new CatchResult(List.of(), Optional.empty());
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean isFish() {
        return this.entry.map(entry -> entry instanceof FishData).orElse(false);
    }

    public boolean isCrate() {
        return this.entry.map(entry -> entry instanceof CrateData).orElse(false);
    }

    public boolean isLoot() {
        return this.entry.map(entry -> entry instanceof FishingLootData).orElse(false);
    }
}

