/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.data.ModAssociatedEntry;
import com.li64.tide.data.commands.TestType;
import com.li64.tide.data.fishing.CatchResult;
import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.conditions.FishingCondition;
import com.li64.tide.data.fishing.conditions.types.AboveCondition;
import com.li64.tide.data.fishing.conditions.types.BelowCondition;
import com.li64.tide.data.fishing.conditions.types.DepthRangeCondition;
import com.li64.tide.data.fishing.conditions.types.DimensionsCondition;
import com.li64.tide.data.fishing.conditions.types.FishingMediumCondition;
import com.li64.tide.data.fishing.conditions.types.FreshwaterCondition;
import com.li64.tide.data.fishing.conditions.types.OpenWaterCondition;
import com.li64.tide.data.fishing.conditions.types.SaltwaterCondition;
import com.li64.tide.data.fishing.mediums.FishingMedium;
import com.li64.tide.data.fishing.modifiers.FishingModifier;
import com.li64.tide.data.fishing.selector.FishingEntry;
import com.li64.tide.data.loot.LootTableRef;
import com.li64.tide.datagen.fabric.providers.SimpleDataOutput;
import com.li64.tide.util.TideUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4651;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public record CrateData(class_4651 blockProvider, Optional<class_2960> lootTable, List<String> associatedMods, List<FishingCondition> conditions, List<FishingModifier> modifiers, double weight, double quality) implements FishingEntry,
ModAssociatedEntry
{
    public static final Codec<CrateData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("block").forGetter(CrateData::blockProvider), (App)class_2960.field_25139.optionalFieldOf("loot_table").forGetter(CrateData::lootTable), (App)Codec.STRING.listOf().optionalFieldOf("associated_mods", List.of()).forGetter(CrateData::associatedMods), (App)FishingCondition.CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(CrateData::conditions), (App)FishingModifier.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(CrateData::modifiers), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)0.0).forGetter(CrateData::weight), (App)Codec.DOUBLE.optionalFieldOf("quality", (Object)0.0).forGetter(CrateData::quality)).apply((Applicative)instance, CrateData::new));

    @Override
    public double weight(FishingContext context) {
        return this.modifyWeight(this.weight, this.quality, this.modifiers, context);
    }

    @Override
    public boolean shouldKeep(FishingContext context) {
        return this.conditions().stream().allMatch(condition -> condition.test(context));
    }

    @Override
    public CatchResult getResult(FishingContext context) {
        MinecraftServer server = context.level().method_8503();
        if (this.lootTable.isEmpty()) {
            return this.createResult(List.of());
        }
        class_52 table = TideUtils.getLootTable(this.lootTable.get(), server);
        return this.createResult((List<class_1799>)table.method_51878(context.createFishingLootParams()));
    }

    @Override
    public boolean matchesTestType(TestType type) {
        return type == TestType.CRATES;
    }

    @Override
    public class_5250 getTestKey() {
        if (this.lootTable.isEmpty()) {
            return class_2561.method_43471((String)"commands.fishing.entries.crate.unknown");
        }
        class_2960 tableLocation = this.lootTable.get();
        return class_2561.method_43471((String)"commands.fishing.entries.crate").method_27693(" \"").method_10852((class_2561)class_2561.method_43470((String)tableLocation.toString())).method_27693("\"");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private class_4651 block;
        private class_2960 lootKey;
        private final List<FishingCondition> conditions = new ArrayList<FishingCondition>();
        private final List<FishingModifier> modifiers = new ArrayList<FishingModifier>();
        private double weight = 1.0;
        private double quality = 0.0;

        private Builder() {
        }

        public Builder block(class_2248 block) {
            this.block = class_4651.method_38432((class_2248)block);
            return this;
        }

        public Builder block(class_4651 block) {
            this.block = block;
            return this;
        }

        public Builder lootTable(LootTableRef lootKey) {
            return this.lootTable(lootKey.get());
        }

        public Builder lootTable(class_5321<class_52> lootKey) {
            return this.lootTable(lootKey.method_29177());
        }

        public Builder lootTable(class_2960 lootKey) {
            this.lootKey = lootKey;
            return this;
        }

        public Builder condition(FishingCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder conditions(List<FishingCondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public Builder modifier(FishingModifier modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        public Builder modifiers(List<FishingModifier> modifiers) {
            this.modifiers.addAll(modifiers);
            return this;
        }

        public Builder saltwater() {
            return this.condition(new SaltwaterCondition());
        }

        public Builder freshwater() {
            return this.condition(new FreshwaterCondition());
        }

        public Builder overworld() {
            return this.dimensions(List.of(class_1937.field_25179));
        }

        public Builder nether() {
            return this.dimensions(List.of(class_1937.field_25180));
        }

        public Builder end() {
            return this.dimensions(List.of(class_1937.field_25181));
        }

        public Builder water() {
            return this.medium(FishingMedium.WATER);
        }

        public Builder lava() {
            return this.medium(FishingMedium.LAVA);
        }

        public Builder surface() {
            return this.above(40);
        }

        public Builder above(int y) {
            return this.condition(new AboveCondition(y));
        }

        public Builder below(int y) {
            return this.condition(new BelowCondition(y));
        }

        public Builder elevationRange(int minY, int maxY) {
            return this.condition(new DepthRangeCondition(minY, maxY));
        }

        public Builder openWater(boolean inOpenWater) {
            return this.condition(new OpenWaterCondition(inOpenWater));
        }

        public Builder dimensions(List<class_5321<class_1937>> dimensions) {
            return this.condition(new DimensionsCondition(dimensions));
        }

        public Builder medium(FishingMedium medium) {
            return this.condition(new FishingMediumCondition(medium));
        }

        public Builder selectionWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder selectionQuality(double quality) {
            this.quality = quality;
            return this;
        }

        public void build(SimpleDataOutput<CrateData> output) {
            this.build(this.lootKey, output);
        }

        public void build(String path, SimpleDataOutput<CrateData> output) {
            this.build(Tide.resource(path), output);
        }

        public void build(class_2960 path, SimpleDataOutput<CrateData> output) {
            output.accept(path, this.build());
        }

        public CrateData build() {
            if (this.block == null) {
                throw new IllegalStateException("Crate block provider must be provided");
            }
            return new CrateData(this.block, Optional.ofNullable(this.lootKey), List.of(), (List<FishingCondition>)ImmutableList.copyOf(this.conditions), (List<FishingModifier>)ImmutableList.copyOf(this.modifiers), this.weight, this.quality);
        }
    }
}

