/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.TideConfig;
import com.li64.tide.compat.seasons.Season;
import com.li64.tide.data.ModAssociatedEntry;
import com.li64.tide.data.SendableDataMap;
import com.li64.tide.data.TideData;
import com.li64.tide.data.commands.TestType;
import com.li64.tide.data.fishing.CatchResult;
import com.li64.tide.data.fishing.DisplayData;
import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.MinigameBehavior;
import com.li64.tide.data.fishing.ProfileData;
import com.li64.tide.data.fishing.SizeData;
import com.li64.tide.data.fishing.conditions.FishingCondition;
import com.li64.tide.data.fishing.conditions.types.AboveCondition;
import com.li64.tide.data.fishing.conditions.types.BelowCondition;
import com.li64.tide.data.fishing.conditions.types.BiomeWhitelistCondition;
import com.li64.tide.data.fishing.conditions.types.DepthRangeCondition;
import com.li64.tide.data.fishing.conditions.types.DimensionsCondition;
import com.li64.tide.data.fishing.conditions.types.EitherCondition;
import com.li64.tide.data.fishing.conditions.types.FishingMediumCondition;
import com.li64.tide.data.fishing.conditions.types.FreshwaterCondition;
import com.li64.tide.data.fishing.conditions.types.SaltwaterCondition;
import com.li64.tide.data.fishing.conditions.types.SeasonsCondition;
import com.li64.tide.data.fishing.conditions.types.StructuresCondition;
import com.li64.tide.data.fishing.conditions.types.TimeOfDayCondition;
import com.li64.tide.data.fishing.conditions.types.TimeRange;
import com.li64.tide.data.fishing.conditions.types.WeatherCondition;
import com.li64.tide.data.fishing.conditions.types.WeatherType;
import com.li64.tide.data.fishing.mediums.FishingMedium;
import com.li64.tide.data.fishing.modifiers.FishingModifier;
import com.li64.tide.data.fishing.modifiers.types.TemperatureModifier;
import com.li64.tide.data.fishing.selector.FishingEntry;
import com.li64.tide.data.item.TideItemData;
import com.li64.tide.data.journal.FishRarity;
import com.li64.tide.data.journal.JournalGroup;
import com.li64.tide.datagen.fabric.providers.SimpleDataOutput;
import com.li64.tide.util.TideUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_77;
import net.minecraft.class_7876;
import net.minecraft.class_79;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public record FishData(class_5321<class_1792> fishKey, List<String> associatedMods, Optional<class_6880<class_1792>> bucket, List<FishingCondition> conditions, List<FishingModifier> modifiers, double weight, double quality, float strength, float speed, boolean showInJournal, ProfileData profile, MinigameBehavior behavior, Optional<SizeData> size, Optional<DisplayData> display, Optional<class_6880<class_1792>> parent) implements FishingEntry,
ModAssociatedEntry
{
    public static class_52 VANILLA_FISH_TABLE;
    private static Map<class_1792, FishData> FISH_BY_ITEM;
    private static Map<class_1792, FishData> FISH_BY_BUCKET;
    private static Map<class_1792, List<FishData>> MERGER_MAP;
    public static final Codec<FishData> CODEC;

    public static void buildMaps() {
        FISH_BY_ITEM = new HashMap<class_1792, FishData>();
        FISH_BY_BUCKET = new HashMap<class_1792, FishData>();
        MERGER_MAP = new HashMap<class_1792, List<FishData>>();
        ((SendableDataMap)TideData.FISH.get()).values().forEach(FishData::register);
        if (!TideData.FISH.hasGenerated()) {
            TideData.FISH.acceptGenerated(FishData.createGeneratedFishData()).values().forEach(FishData::register);
        }
        MERGER_MAP.forEach((parent, mergers) -> {
            Optional<FishData> parentData = FishData.get(parent);
            if (parentData.isEmpty()) {
                return;
            }
            mergers.forEach(data -> {
                FISH_BY_ITEM.put((class_1792)data.fish().comp_349(), (FishData)parentData.get());
                data.bucket().ifPresent(bucket -> FISH_BY_BUCKET.put((class_1792)bucket.comp_349(), (FishData)parentData.get()));
            });
        });
    }

    private static void register(FishData data) {
        if (data.parent().isPresent()) {
            class_1792 parent = (class_1792)data.parent().get().comp_349();
            if (MERGER_MAP.containsKey(parent)) {
                MERGER_MAP.get(parent).add(data);
            } else {
                ArrayList<FishData> mergers = new ArrayList<FishData>();
                mergers.add(data);
                MERGER_MAP.put(parent, mergers);
            }
            return;
        }
        FISH_BY_ITEM.put((class_1792)data.fish().comp_349(), data);
        data.bucket().ifPresent(bucket -> FISH_BY_BUCKET.put((class_1792)bucket.comp_349(), data));
    }

    public static Optional<FishData> get(class_1799 fish) {
        return FishData.get(fish.method_7909());
    }

    public static Optional<FishData> get(class_1297 entity) {
        return FishData.get(entity.method_5864());
    }

    public static Optional<FishData> get(class_1299<?> entityType) {
        class_2960 key = class_7923.field_41177.method_10221(entityType);
        return class_7923.field_41178.method_17966(key).flatMap(FishData::get);
    }

    public static Optional<FishData> get(class_1792 fish) {
        if (FISH_BY_ITEM == null) {
            Tide.LOG.error("Tried to access data for fish \"{}\" before fish data was loaded", (Object)fish);
            return Optional.empty();
        }
        return Optional.ofNullable(FISH_BY_ITEM.get(fish));
    }

    public static Optional<FishData> fromBucket(class_1799 bucket) {
        if (FISH_BY_BUCKET == null) {
            Tide.LOG.error("Tried to access data for bucket \"{}\" before fish data was loaded", (Object)bucket);
            return Optional.empty();
        }
        return Optional.ofNullable(FISH_BY_BUCKET.get(bucket.method_7909()));
    }

    public static Optional<FishData> getExact(class_1799 fish) {
        return FishData.getExact(fish.method_7909());
    }

    public static Optional<FishData> getExact(class_1792 fish) {
        Optional<FishData> dataOp = FishData.get(fish);
        if (dataOp.isEmpty() || dataOp.get().fish().comp_349() == fish) {
            return dataOp;
        }
        Tide.LOG.info("additional checks required");
        List<FishData> mergers = MERGER_MAP.get(dataOp.get().fish().comp_349());
        return mergers.stream().filter(d -> d.fish().comp_349() == fish).findFirst();
    }

    public static FishData getOrThrow(class_1799 fish) {
        return FishData.get(fish).orElseThrow();
    }

    public static class_1799 randomFish() {
        return new class_1799(((FishData)((SendableDataMap)TideData.FISH.get()).values().get(new Random().nextInt(((SendableDataMap)TideData.FISH.get()).count()))).fish());
    }

    public class_6880<class_1792> fish() {
        return (class_6880)class_7923.field_41178.method_40264(this.fishKey).orElseThrow(() -> new IllegalStateException("could not find item " + String.valueOf(this.fishKey)));
    }

    @Override
    public boolean isValid() {
        return class_7923.field_41178.method_40264(this.fishKey).isPresent() && ModAssociatedEntry.super.isValid();
    }

    @Override
    public String invalidReason() {
        if (!ModAssociatedEntry.super.isValid()) {
            return ModAssociatedEntry.super.invalidReason();
        }
        return "fish item '" + String.valueOf(this.fishKey.method_29177()) + "' was not found";
    }

    public boolean hasJournalEntry() {
        return this.isOriginal() && this.showInJournal();
    }

    public boolean isOriginal() {
        return this.parent().isEmpty();
    }

    @Override
    public double weight(FishingContext context) {
        return this.modifyWeight(this.weight, this.quality, this.modifiers, context);
    }

    @Override
    public boolean shouldKeep(FishingContext context) {
        return this.conditions().stream().allMatch(condition -> condition.test(context));
    }

    @Override
    public CatchResult getResult(FishingContext context) {
        class_1799 stack = new class_1799((class_1935)this.fish().comp_349());
        if (Tide.CONFIG.items.fishItemSizes == TideConfig.Items.SizeMode.ALWAYS && this.size().isPresent()) {
            TideItemData.FISH_LENGTH.set(stack, this.getRandomLength(context.rng()));
        }
        if (Tide.CONFIG.items.bucketableFishItems == TideConfig.Items.BucketableMode.WHEN_LIVING && this.bucket().isPresent()) {
            TideItemData.CATCH_TIMESTAMP.set(stack, context.level().method_8532());
        }
        return this.createResult(stack);
    }

    public double getRandomLength(class_5819 rng) {
        SizeData sizeData = this.size().orElse(null);
        if (sizeData == null) {
            return 0.0;
        }
        return sizeData.sample(rng, 0.0);
    }

    public double getAverageLength() {
        SizeData sizeData = this.size().orElse(null);
        if (sizeData == null) {
            return 0.0;
        }
        return (sizeData.typicalHighCm() + sizeData.typicalLowCm()) / 2.0;
    }

    @Override
    public boolean matchesTestType(TestType type) {
        return type == TestType.FISH;
    }

    @Override
    public class_5250 getTestKey() {
        return class_2561.method_43471((String)((class_1792)this.fish().comp_349()).method_7876());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Map<class_2960, FishData> createGeneratedFishData() {
        HashMap<class_2960, FishData> entries = new HashMap<class_2960, FishData>();
        if (VANILLA_FISH_TABLE == null || VANILLA_FISH_TABLE == class_52.field_948) {
            Tide.LOG.error("Failed to find vanilla fishing loot table during post-process! Some compat functionality may not be present.");
            return entries;
        }
        for (class_55 pool : FishData.VANILLA_FISH_TABLE.field_943) {
            for (class_79 container : pool.field_953) {
                if (!(container instanceof class_77)) continue;
                class_77 lootItem = (class_77)container;
                class_1792 item = lootItem.field_987;
                class_2960 key = class_7923.field_41178.method_10221((Object)item);
                if (Tide.CONFIG.general.autoFishDataBlacklist.contains(key.toString()) || FishData.get(item).isPresent()) continue;
                Tide.LOG.info("Found unknown fish \"{}\" in vanilla fishing loot table, auto-generating fish data", (Object)item);
                FishData data = FishData.builder().fish(item).strength(0.5f).speed(0.9f).selectionWeight(30.0).overworld().water().surface().journalGroup(JournalGroup.MISC).build();
                entries.put(key.method_45138("generated/"), data);
            }
        }
        if (!entries.isEmpty()) {
            Tide.LOG.info("Auto-generated {} fish data entries", (Object)entries.size());
        }
        return entries;
    }

    static {
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41197).fieldOf("fish").forGetter(FishData::fishKey), (App)Codec.STRING.listOf().optionalFieldOf("associated_mods", List.of()).forGetter(FishData::associatedMods), (App)class_7923.field_41178.method_40294().optionalFieldOf("bucket").forGetter(FishData::bucket), (App)FishingCondition.CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(FishData::conditions), (App)FishingModifier.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(FishData::modifiers), (App)Codec.DOUBLE.optionalFieldOf("selection_weight", (Object)0.0).forGetter(FishData::weight), (App)Codec.DOUBLE.optionalFieldOf("selection_quality", (Object)0.0).forGetter(FishData::quality), (App)Codec.FLOAT.optionalFieldOf("strength", (Object)Float.valueOf(0.3f)).forGetter(FishData::strength), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(FishData::speed), (App)Codec.BOOL.optionalFieldOf("show_in_journal", (Object)true).forGetter(FishData::showInJournal), (App)ProfileData.CODEC.optionalFieldOf("journal_profile", (Object)new ProfileData()).forGetter(FishData::profile), (App)MinigameBehavior.CODEC.optionalFieldOf("behavior", (Object)MinigameBehavior.SINE).forGetter(FishData::behavior), (App)SizeData.CODEC.optionalFieldOf("size").forGetter(FishData::size), (App)DisplayData.CODEC.optionalFieldOf("display_data").forGetter(FishData::display), (App)class_7923.field_41178.method_40294().optionalFieldOf("parent").forGetter(FishData::parent)).apply((Applicative)instance, FishData::new));
    }

    public static class Builder {
        private class_6880<class_1792> fish;
        private class_6880<class_1792> bucket;
        private class_6880<class_1792> parent;
        private final ProfileData.Builder profile = ProfileData.builder();
        private final List<FishingCondition> conditions = new ArrayList<FishingCondition>();
        private final List<FishingModifier> modifiers = new ArrayList<FishingModifier>();
        private SizeData size = null;
        private DisplayData display = null;
        private double weight = 0.0;
        private double quality = 0.0;
        private float strength = 0.3f;
        private float speed = 1.0f;
        private MinigameBehavior behavior = MinigameBehavior.SINE;

        private Builder() {
        }

        public Builder fish(class_1792 fish) {
            this.fish = class_7923.field_41178.method_47983((Object)fish);
            class_2960 key = class_7923.field_41178.method_10221((Object)fish);
            return this.journalDescription("journal.description." + key.method_12836() + "." + key.method_12832());
        }

        public Builder fish(String namespace, String path) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)Tide.resource(namespace, path));
            this.fish = class_6880.class_6883.method_40234((class_7876)class_7923.field_41178.method_46770(), (class_5321)key);
            return this.journalDescription("journal.description." + namespace + "." + path);
        }

        public Builder bucket(class_1792 bucket) {
            this.bucket = class_7923.field_41178.method_47983((Object)bucket);
            return this;
        }

        public Builder either(FishingCondition a, FishingCondition b) {
            return this.condition(new EitherCondition(a, b));
        }

        public Builder medium(FishingMedium medium) {
            return this.condition(new FishingMediumCondition(medium));
        }

        public Builder inStructure(class_5321<class_3195> structure) {
            return this.condition(StructuresCondition.only(structure));
        }

        public Builder foundIn(List<class_6862<class_1959>> foundIn) {
            return this.condition(BiomeWhitelistCondition.fromTagList(foundIn));
        }

        public Builder foundIn(class_6862<class_1959> foundIn) {
            return this.condition(BiomeWhitelistCondition.fromTagList(List.of(foundIn)));
        }

        public Builder dimensions(List<class_5321<class_1937>> dimensions) {
            return this.condition(new DimensionsCondition(dimensions));
        }

        public Builder overworld() {
            return this.dimensions(List.of(class_1937.field_25179));
        }

        public Builder nether() {
            return this.dimensions(List.of(class_1937.field_25180));
        }

        public Builder end() {
            return this.dimensions(List.of(class_1937.field_25181));
        }

        public Builder water() {
            return this.medium(FishingMedium.WATER);
        }

        public Builder surface() {
            return this.above(40);
        }

        public Builder above(int y) {
            return this.condition(new AboveCondition(y));
        }

        public Builder below(int y) {
            return this.condition(new BelowCondition(y));
        }

        public Builder elevationRange(int minY, int maxY) {
            return this.condition(new DepthRangeCondition(minY, maxY));
        }

        public Builder freshwater() {
            return this.condition(new FreshwaterCondition());
        }

        public Builder saltwater() {
            return this.condition(new SaltwaterCondition());
        }

        public Builder temperature(float preferred, float tolerance) {
            return this.modifier(new TemperatureModifier(preferred, tolerance));
        }

        public Builder weather(WeatherType ... weather) {
            return this.condition(WeatherCondition.anyOf(weather));
        }

        public Builder timeOfDay(TimeRange ... ranges) {
            return this.condition(new TimeOfDayCondition(Arrays.stream(ranges).toList()));
        }

        public Builder seasons(Season ... seasons) {
            return this.condition(SeasonsCondition.fromSeasons(seasons));
        }

        public Builder condition(FishingCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder conditions(List<FishingCondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public Builder modifier(FishingModifier modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        public Builder modifiers(List<FishingModifier> modifiers) {
            this.modifiers.addAll(modifiers);
            return this;
        }

        public Builder selectionWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder selectionQuality(double quality) {
            this.quality = quality;
            return this;
        }

        public Builder strength(float strength) {
            this.strength = strength;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder size(double lowCm, double highCm, double recordCm) {
            this.size = new SizeData(lowCm, highCm, recordCm);
            return this;
        }

        public Builder behavior(MinigameBehavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public Builder displayData(Consumer<DisplayData.Builder> modifiers) {
            DisplayData.Builder builder = DisplayData.builder();
            if (this.fish instanceof class_6880.class_6883) {
                class_2960 id = TideUtils.holderId(this.fish);
                builder.entityType(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)id));
            } else {
                builder.entityType((class_1299)class_7923.field_41177.method_10223(TideUtils.holderId(this.fish)));
            }
            modifiers.accept(builder);
            this.display = builder.build();
            return this;
        }

        public Builder journalDescription(String description) {
            this.profile.description(description);
            return this;
        }

        public Builder journalLocation(String location) {
            this.profile.location(location);
            return this;
        }

        public Builder journalAltSprite(int size) {
            class_2960 location = (class_2960)this.fish.method_40229().map(class_5321::method_29177, arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0));
            this.profile.altSprite(location.method_45134(path -> "textures/item/" + path + "_full.png"), size);
            return this;
        }

        public Builder journalRarity(FishRarity rarity) {
            this.profile.rarity(rarity);
            return this;
        }

        public Builder journalGroup(JournalGroup group) {
            this.profile.group(group);
            return this;
        }

        public Builder parent(class_1792 parent) {
            this.parent = class_7923.field_41178.method_47983((Object)parent);
            return this;
        }

        public void build(class_2960 path, SimpleDataOutput<FishData> output) {
            output.accept(path, this.build());
        }

        public void build(String group, SimpleDataOutput<FishData> output) {
            class_2960 key = TideUtils.holderId(this.fish);
            output.accept(Tide.resource(key.method_12836().replace('-', '_'), group + "/" + key.method_12832()), this.build());
        }

        public void build(SimpleDataOutput<FishData> output) {
            this.build(this.profile.getGroup().method_15434(), output);
        }

        public FishData build() {
            if (this.fish == null) {
                throw new IllegalStateException("Fish item must be provided");
            }
            return new FishData((class_5321<class_1792>)((class_5321)this.fish.method_40229().map(Function.identity(), item -> (class_5321)class_7923.field_41178.method_29113(item).orElseThrow())), List.of(), Optional.ofNullable(this.bucket), (List<FishingCondition>)ImmutableList.copyOf(this.conditions), (List<FishingModifier>)ImmutableList.copyOf(this.modifiers), this.weight, this.quality, this.strength, this.speed, true, this.profile.build(), this.behavior, Optional.ofNullable(this.size), Optional.ofNullable(this.display), Optional.ofNullable(this.parent));
        }
    }
}

