/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing;

import java.util.Optional;
import net.minecraft.class_5819;

public final class FishSizeModel {
    private static final double Z10 = -1.2815515655446004;
    private static final double Z90 = 1.2815515655446004;

    private static LogNormalParams fitFromTypicalRange(double typicalLowCm, double typicalHighCm) {
        double lnLow = Math.log(typicalLowCm);
        double lnHigh = Math.log(typicalHighCm);
        double sigma = (lnHigh - lnLow) / 2.5631031310892007;
        double mu = lnLow - -1.2815515655446004 * sigma;
        return new LogNormalParams(mu, sigma);
    }

    private static double logNormalDist(LogNormalParams params, class_5819 rng) {
        return Math.exp(params.mu + params.sigma * rng.method_43059());
    }

    public static double sampleLengthCm(class_5819 rng, double typicalLowCm, double typicalHighCm, Optional<Double> recordLowCm, double recordHighCm, double trophyChance) {
        LogNormalParams params = FishSizeModel.fitFromTypicalRange(typicalLowCm, typicalHighCm);
        double absoluteMin = recordLowCm.orElse(0.6 * typicalLowCm);
        double length = FishSizeModel.logNormalDist(params, rng);
        if (rng.method_43058() < trophyChance) {
            while ((length = FishSizeModel.logNormalDist(params, rng)) < typicalHighCm) {
            }
        }
        if (length <= absoluteMin) {
            length = Math.max(FishSizeModel.logNormalDist(params, rng), absoluteMin);
        }
        if (length >= recordHighCm) {
            length = Math.min(FishSizeModel.logNormalDist(params, rng), recordHighCm);
        }
        return length;
    }

    private record LogNormalParams(double mu, double sigma) {
    }
}

