/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.data.ModAssociatedEntry;
import com.li64.tide.data.fishing.CatchResult;
import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.conditions.FishingCondition;
import com.li64.tide.data.fishing.conditions.types.AboveCondition;
import com.li64.tide.data.fishing.conditions.types.BelowCondition;
import com.li64.tide.data.fishing.conditions.types.DimensionsCondition;
import com.li64.tide.data.fishing.conditions.types.FishingMediumCondition;
import com.li64.tide.data.fishing.conditions.types.OpenWaterCondition;
import com.li64.tide.data.fishing.mediums.FishingMedium;
import com.li64.tide.data.fishing.modifiers.FishingModifier;
import com.li64.tide.data.fishing.selector.FishingEntry;
import com.li64.tide.data.loot.LootTableRef;
import com.li64.tide.datagen.fabric.providers.SimpleDataOutput;
import com.li64.tide.util.TideUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public record FishingLootData(class_2960 lootTable, List<String> associatedMods, List<FishingCondition> conditions, List<FishingModifier> modifiers, double weight, double quality) implements FishingEntry,
ModAssociatedEntry
{
    public static final Codec<FishingLootData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("loot_table").forGetter(FishingLootData::lootTable), (App)Codec.STRING.listOf().optionalFieldOf("associated_mods", List.of()).forGetter(FishingLootData::associatedMods), (App)FishingCondition.CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(FishingLootData::conditions), (App)FishingModifier.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(FishingLootData::modifiers), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)0.0).forGetter(FishingLootData::weight), (App)Codec.DOUBLE.optionalFieldOf("quality", (Object)0.0).forGetter(FishingLootData::quality)).apply((Applicative)instance, FishingLootData::new));

    @Override
    public double weight(FishingContext context) {
        return this.modifyWeight(this.weight, this.quality, this.modifiers, context);
    }

    @Override
    public boolean shouldKeep(FishingContext context) {
        if (this.conditions().isEmpty()) {
            Tide.LOG.error("{} has no conditions!", (Object)this.getTestKey().getString());
        }
        return this.conditions().stream().allMatch(condition -> condition.test(context));
    }

    @Override
    public CatchResult getResult(FishingContext context) {
        MinecraftServer server = context.level().method_8503();
        class_52 table = TideUtils.getLootTable(this.lootTable, server);
        return this.createResult((List<class_1799>)table.method_51878(context.createFishingLootParams()));
    }

    @Override
    public class_5250 getTestKey() {
        return class_2561.method_43471((String)"commands.fishing.entries.loot_table").method_27693(" \"").method_10852((class_2561)class_2561.method_43470((String)this.lootTable.toString())).method_27693("\"");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private class_2960 lootKey;
        private final List<FishingCondition> conditions = new ArrayList<FishingCondition>();
        private final List<FishingModifier> modifiers = new ArrayList<FishingModifier>();
        private double weight = 0.0;
        private double quality = 0.0;

        private Builder() {
        }

        public Builder lootTable(LootTableRef lootKey) {
            return this.lootTable(lootKey.get());
        }

        public Builder lootTable(class_5321<class_52> lootKey) {
            return this.lootTable(lootKey.method_29177());
        }

        public Builder lootTable(class_2960 lootKey) {
            this.lootKey = lootKey;
            return this;
        }

        public Builder condition(FishingCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder conditions(List<FishingCondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public Builder modifier(FishingModifier modifier) {
            this.modifiers.add(modifier);
            return this;
        }

        public Builder modifiers(List<FishingModifier> modifiers) {
            this.modifiers.addAll(modifiers);
            return this;
        }

        public Builder overworld() {
            return this.dimensions(List.of(class_1937.field_25179));
        }

        public Builder nether() {
            return this.dimensions(List.of(class_1937.field_25180));
        }

        public Builder water() {
            return this.medium(FishingMedium.WATER);
        }

        public Builder lava() {
            return this.medium(FishingMedium.LAVA);
        }

        public Builder surface() {
            return this.above(40);
        }

        public Builder above(int y) {
            return this.condition(new AboveCondition(y));
        }

        public Builder below(int y) {
            return this.condition(new BelowCondition(y));
        }

        public Builder openWater(boolean inOpenWater) {
            return this.condition(new OpenWaterCondition(inOpenWater));
        }

        public Builder dimensions(List<class_5321<class_1937>> dimensions) {
            return this.condition(new DimensionsCondition(dimensions));
        }

        public Builder medium(FishingMedium medium) {
            return this.condition(new FishingMediumCondition(medium));
        }

        public Builder selectionWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder selectionQuality(double quality) {
            this.quality = quality;
            return this;
        }

        public void build(SimpleDataOutput<FishingLootData> output) {
            this.build(this.lootKey, output);
        }

        public void build(String path, SimpleDataOutput<FishingLootData> output) {
            this.build(Tide.resource(path), output);
        }

        public void build(class_2960 path, SimpleDataOutput<FishingLootData> output) {
            output.accept(path, this.build());
        }

        public FishingLootData build() {
            if (this.lootKey == null) {
                throw new IllegalStateException("Loot table key must be provided");
            }
            return new FishingLootData(this.lootKey, List.of(), (List<FishingCondition>)ImmutableList.copyOf(this.conditions), (List<FishingModifier>)ImmutableList.copyOf(this.modifiers), this.weight, this.quality);
        }
    }
}

