/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing.conditions;

import com.li64.tide.Tide;
import com.li64.tide.data.fishing.conditions.FishingCondition;
import com.li64.tide.data.fishing.conditions.types.AboveCondition;
import com.li64.tide.data.fishing.conditions.types.BelowCondition;
import com.li64.tide.data.fishing.conditions.types.BiomeWhitelistCondition;
import com.li64.tide.data.fishing.conditions.types.BlockNearbyCondition;
import com.li64.tide.data.fishing.conditions.types.DepthRangeCondition;
import com.li64.tide.data.fishing.conditions.types.DimensionsCondition;
import com.li64.tide.data.fishing.conditions.types.EitherCondition;
import com.li64.tide.data.fishing.conditions.types.EnchantmentsCondition;
import com.li64.tide.data.fishing.conditions.types.FishingMediumCondition;
import com.li64.tide.data.fishing.conditions.types.FreshwaterCondition;
import com.li64.tide.data.fishing.conditions.types.LuckCondition;
import com.li64.tide.data.fishing.conditions.types.MoonPhaseCondition;
import com.li64.tide.data.fishing.conditions.types.NotCondition;
import com.li64.tide.data.fishing.conditions.types.OpenWaterCondition;
import com.li64.tide.data.fishing.conditions.types.SaltwaterCondition;
import com.li64.tide.data.fishing.conditions.types.SeasonsCondition;
import com.li64.tide.data.fishing.conditions.types.StructuresCondition;
import com.li64.tide.data.fishing.conditions.types.TimeOfDayCondition;
import com.li64.tide.data.fishing.conditions.types.WeatherCondition;
import com.li64.tide.registries.TideRegistries;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public interface FishingConditionType<T extends FishingCondition> {
    public static final FishingConditionType<EitherCondition> EITHER = FishingConditionType.register("either", EitherCondition.CODEC);
    public static final FishingConditionType<NotCondition> NOT = FishingConditionType.register("not", NotCondition.CODEC);
    public static final FishingConditionType<FreshwaterCondition> FRESHWATER = FishingConditionType.register("freshwater", FreshwaterCondition.CODEC);
    public static final FishingConditionType<SaltwaterCondition> SALTWATER = FishingConditionType.register("saltwater", SaltwaterCondition.CODEC);
    public static final FishingConditionType<DimensionsCondition> DIMENSION = FishingConditionType.register("dimension", DimensionsCondition.CODEC);
    public static final FishingConditionType<BiomeWhitelistCondition> BIOME_WHITELIST = FishingConditionType.register("found_in", BiomeWhitelistCondition.CODEC);
    public static final FishingConditionType<TimeOfDayCondition> TIME_OF_DAY = FishingConditionType.register("time_of_day", TimeOfDayCondition.CODEC);
    public static final FishingConditionType<FishingMediumCondition> MEDIUM = FishingConditionType.register("fluid", FishingMediumCondition.CODEC);
    public static final FishingConditionType<AboveCondition> ABOVE = FishingConditionType.register("above", AboveCondition.CODEC);
    public static final FishingConditionType<BelowCondition> BELOW = FishingConditionType.register("below", BelowCondition.CODEC);
    public static final FishingConditionType<DepthRangeCondition> DEPTH_RANGE = FishingConditionType.register("depth_range", DepthRangeCondition.CODEC);
    public static final FishingConditionType<StructuresCondition> STRUCTURES = FishingConditionType.register("found_in_structures", StructuresCondition.CODEC);
    public static final FishingConditionType<LuckCondition> LUCK = FishingConditionType.register("luck", LuckCondition.CODEC);
    public static final FishingConditionType<MoonPhaseCondition> MOON_PHASE = FishingConditionType.register("moon_phase", MoonPhaseCondition.CODEC);
    public static final FishingConditionType<WeatherCondition> WEATHER = FishingConditionType.register("weather", WeatherCondition.CODEC);
    public static final FishingConditionType<OpenWaterCondition> OPEN_WATER = FishingConditionType.register("open_water", OpenWaterCondition.CODEC);
    public static final FishingConditionType<BlockNearbyCondition> BLOCK_NEARBY = FishingConditionType.register("block_nearby", BlockNearbyCondition.CODEC);
    public static final FishingConditionType<SeasonsCondition> SEASONS = FishingConditionType.register("seasons", SeasonsCondition.CODEC);
    public static final FishingConditionType<EnchantmentsCondition> HAS_ENCHANTMENTS = FishingConditionType.register("has_enchantments", EnchantmentsCondition.CODEC);

    public static void register() {
        Tide.LOG.info("Registering fishing conditions");
    }

    public MapCodec<T> codec();

    public static <T extends FishingCondition> FishingConditionType<T> register(String name, MapCodec<T> codec) {
        return FishingConditionType.register(Tide.resource(name), codec);
    }

    public static <T extends FishingCondition> FishingConditionType<T> register(class_2960 name, MapCodec<T> codec) {
        return (FishingConditionType)class_2378.method_10230(TideRegistries.FISHING_CONDITIONS, (class_2960)name, () -> codec);
    }
}

