/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing.conditions.types;

import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.conditions.FishingCondition;
import com.li64.tide.data.fishing.conditions.FishingConditionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class BiomeWhitelistCondition
extends FishingCondition {
    public static final MapCodec<BiomeWhitelistCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_39274.listOf().fieldOf("biomes").forGetter(BiomeWhitelistCondition::toData)).apply((Applicative)instance, BiomeWhitelistCondition::fromData));
    private final List<class_6862<class_1959>> tags;
    private final List<class_2960> biomes;

    private static BiomeWhitelistCondition fromData(List<class_5699.class_7476> data) {
        List<class_6862<class_1959>> tags = data.stream().filter(class_5699.class_7476::comp_814).map(entry -> class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)entry.comp_813())).toList();
        List<class_2960> biomes = data.stream().filter(entry -> !entry.comp_814()).map(class_5699.class_7476::comp_813).toList();
        return new BiomeWhitelistCondition(tags, biomes);
    }

    public BiomeWhitelistCondition(List<class_6862<class_1959>> tags, List<class_2960> biomes) {
        this.tags = tags;
        this.biomes = biomes;
    }

    public static BiomeWhitelistCondition fromTag(class_6862<class_1959> tag) {
        return BiomeWhitelistCondition.fromTagList(List.of(tag));
    }

    public static BiomeWhitelistCondition fromTagList(List<class_6862<class_1959>> tagList) {
        return new BiomeWhitelistCondition(tagList, List.of());
    }

    public List<class_5699.class_7476> toData() {
        ArrayList<class_5699.class_7476> data = new ArrayList<class_5699.class_7476>(this.tags.size() + this.biomes.size());
        data.addAll(this.tags.stream().map(tag -> new class_5699.class_7476(tag.comp_327(), true)).toList());
        data.addAll(this.biomes.stream().map(id -> new class_5699.class_7476(id, false)).toList());
        return data;
    }

    @Override
    public FishingConditionType<?> type() {
        return FishingConditionType.BIOME_WHITELIST;
    }

    @Override
    public boolean test(FishingContext context) {
        return this.tags.stream().anyMatch(tag -> context.nearestBiome().method_40220(tag) || context.exactBiome().method_40220(tag)) || this.biomes.stream().anyMatch(id -> context.nearestBiome().method_40226(id) || context.exactBiome().method_40226(id));
    }
}

