/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing.conditions.types;

import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.conditions.FishingCondition;
import com.li64.tide.data.fishing.conditions.FishingConditionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class LuckCondition
extends FishingCondition {
    public static final MapCodec<LuckCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)0).forGetter(LuckCondition::getMinLuck), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(LuckCondition::getMaxLuck)).apply((Applicative)instance, LuckCondition::new));
    private final int min;
    private final int max;

    public static LuckCondition minimum(int min) {
        return new LuckCondition(min, Integer.MAX_VALUE);
    }

    public static LuckCondition maximum(int max) {
        return new LuckCondition(0, max);
    }

    public LuckCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMinLuck() {
        return this.min;
    }

    public int getMaxLuck() {
        return this.max;
    }

    @Override
    public FishingConditionType<?> type() {
        return FishingConditionType.LUCK;
    }

    @Override
    public boolean test(FishingContext context) {
        return context.luck() >= this.min && context.luck() <= this.max;
    }
}

