/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing.mediums;

import com.li64.tide.Tide;
import com.li64.tide.TideConfig;
import com.li64.tide.data.fishing.mediums.FishingMedium;
import com.li64.tide.registries.TideParticleTypes;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;

public class VoidMedium
implements FishingMedium {
    private final Map<class_5321<class_1937>, TideConfig.General.VoidHeightEntry> CACHE = new HashMap<class_5321<class_1937>, TideConfig.General.VoidHeightEntry>();
    private final TideConfig.General.VoidHeightEntry DEFAULT_ENTRY = new TideConfig.General.VoidHeightEntry();
    private final class_2960 id = Tide.resource("void");

    public VoidMedium() {
        Tide.CONFIG.general.fishableVoidHeights.forEach(entry -> {
            class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)entry.dimension));
            this.CACHE.put((class_5321<class_1937>)dimension, (TideConfig.General.VoidHeightEntry)entry);
        });
    }

    @Override
    public class_2960 id() {
        return this.id;
    }

    public boolean isInVoid(class_2338 pos, class_1937 level) {
        return this.isInVoid(pos.method_46558(), level);
    }

    public boolean isInVoid(class_243 pos, class_1937 level) {
        return pos.method_10214() <= (double)this.getVoidSurface(level);
    }

    public int getVoidSurface(class_1937 level) {
        TideConfig.General.VoidHeightEntry entry = this.CACHE.getOrDefault(level.method_27983(), this.DEFAULT_ENTRY);
        if (entry.type == TideConfig.General.VoidHeightEntry.Type.RELATIVE_TO_BOTTOM) {
            return level.method_31607() + entry.height;
        }
        if (entry.type == TideConfig.General.VoidHeightEntry.Type.RELATIVE_TO_TOP) {
            return level.method_31600() + entry.height;
        }
        return entry.height;
    }

    @Override
    public boolean isAt(class_2338 pos, class_3218 level) {
        return pos.method_10264() <= this.getVoidSurface((class_1937)level);
    }

    @Override
    public boolean canFishIn(TideFishingHook hook) {
        return this.getHeight(hook) > 0.0f && hook.canFishInVoid();
    }

    @Override
    public float getHeight(TideFishingHook hook) {
        return Math.min((float)((double)this.getVoidSurface(hook.method_37908()) - hook.method_23318()), 1.0f);
    }

    @Override
    public double biteTimeMultiplier() {
        return 1.8;
    }

    @Override
    public void drawAmbientSplash(TideFishingHook hook, float angleRad, float distance, double x, double y, double z) {
        class_1937 class_19372 = hook.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        level.method_14199((class_2394)TideParticleTypes.VOID_RIPPLE_SMALL, x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void drawFishTrail(TideFishingHook hook, float angleRad, float sin, float cos, double fishX, double fishY, double fishZ) {
        class_1937 class_19372 = hook.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        class_5819 random = hook.getRandom();
        if (random.method_43057() < 0.35f) {
            level.method_14199((class_2394)TideParticleTypes.VOID_RIPPLE_SMALL, fishX, fishY - 0.5, fishZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        float scaledSin = sin * 0.04f;
        float scaledCos = cos * 0.04f;
        level.method_14199((class_2394)class_2398.field_11208, fishX, fishY - 0.1, fishZ, 0, (double)scaledCos, 0.0, (double)(-scaledSin), 1.0);
    }

    @Override
    public void onFishBite(TideFishingHook hook) {
        class_1937 class_19372 = hook.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        class_5819 random = hook.getRandom();
        hook.method_5783(class_3417.field_14660, 0.25f, 1.0f + (random.method_43057() - random.method_43057()) * 0.4f);
        double y = hook.method_23318() + 0.5;
        level.method_14199((class_2394)TideParticleTypes.VOID_RIPPLE_LARGE, hook.method_23317(), y - 0.5, hook.method_23321(), 0, 0.0, 0.0, 0.0, 0.2);
    }
}

