/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing.modifiers.types;

import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.conditions.FishingCondition;
import com.li64.tide.data.fishing.modifiers.FishingModifier;
import com.li64.tide.data.fishing.modifiers.FishingModifierType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class ConditionalModifier
extends FishingModifier {
    public static final MapCodec<ConditionalModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FishingCondition.CODEC.fieldOf("if").forGetter(ConditionalModifier::getCondition), (App)Codec.FLOAT.fieldOf("multiplier").forGetter(ConditionalModifier::getMultiplier)).apply((Applicative)instance, ConditionalModifier::new));
    private final FishingCondition condition;
    private final float multiplier;

    public ConditionalModifier(FishingCondition condition, float multiplier) {
        this.condition = condition;
        this.multiplier = multiplier;
    }

    public FishingCondition getCondition() {
        return this.condition;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    @Override
    public FishingModifierType<?> type() {
        return FishingModifierType.CONDITIONAL;
    }

    @Override
    public double apply(double weight, FishingContext context) {
        return this.condition.test(context) ? weight * (double)this.multiplier : weight;
    }
}

