/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing.modifiers.types;

import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.modifiers.FishingModifier;
import com.li64.tide.data.fishing.modifiers.FishingModifierType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class TemperatureModifier
extends FishingModifier {
    public static final MapCodec<TemperatureModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("preferred_temperature").forGetter(TemperatureModifier::getPreferred), (App)Codec.FLOAT.fieldOf("temperature_tolerance").forGetter(TemperatureModifier::getTolerance)).apply((Applicative)instance, TemperatureModifier::new));
    private final float preferred;
    private final float tolerance;

    public TemperatureModifier(float preferred, float tolerance) {
        this.preferred = preferred;
        this.tolerance = tolerance;
    }

    public float getPreferred() {
        return this.preferred;
    }

    public float getTolerance() {
        return this.tolerance;
    }

    @Override
    public FishingModifierType<?> type() {
        return FishingModifierType.TEMPERATURE;
    }

    @Override
    public double apply(double weight, FishingContext context) {
        double inner = Math.abs((context.temperature() - this.preferred) / this.tolerance);
        double scalar = Math.max(0.0, -(inner * inner) + 1.0);
        return weight * scalar;
    }
}

