/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing.selector;

import com.li64.tide.data.commands.TestType;
import com.li64.tide.data.fishing.CatchResult;
import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.modifiers.FishingModifier;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public interface FishingEntry {
    public double weight(FishingContext var1);

    public boolean shouldKeep(FishingContext var1);

    public CatchResult getResult(FishingContext var1);

    default public CatchResult getResult(FishingContext context, Map<FishingEntry, Double> results, Predicate<FishingEntry> entryTest) {
        return this.getResult(context);
    }

    public static double modifyWeight(double baseWeight, double quality, FishingContext context) {
        return baseWeight + quality * (double)context.luck();
    }

    default public double modifyWeight(double baseWeight, double quality, List<FishingModifier> modifiers, FishingContext context) {
        double weight = FishingEntry.modifyWeight(baseWeight, quality, context);
        if (weight <= 0.0) {
            return 0.0;
        }
        if (modifiers.isEmpty()) {
            return weight;
        }
        for (FishingModifier mod : modifiers) {
            weight = mod.apply(weight, context);
            if (!(weight <= 0.0)) continue;
            return 0.0;
        }
        return weight;
    }

    default public CatchResult createResult(class_1799 stack) {
        return this.createResult(List.of(stack));
    }

    default public CatchResult createResult(List<class_1799> items) {
        return CatchResult.of(items, this);
    }

    default public CatchResult emptyResult() {
        return CatchResult.empty(this);
    }

    default public boolean matchesTestType(TestType type) {
        return type == TestType.LOOT;
    }

    default public class_5250 getTestKey() {
        return class_2561.method_43471((String)"commands.fishing.entries.unspecified");
    }
}

