/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.fishing.selector;

import com.li64.tide.data.fishing.CatchResult;
import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.selector.FishingEntry;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class FishingRandomSelector {
    public static <T extends FishingEntry> CatchResult select(List<T> entries, FishingContext context) {
        return FishingRandomSelector.select(entries, context, null, entry -> false);
    }

    public static <T extends FishingEntry> CatchResult select(List<T> entries, FishingContext context, Map<FishingEntry, Double> testResults, Predicate<FishingEntry> entryTest) {
        if (entries.isEmpty()) {
            return CatchResult.empty();
        }
        List<Pair> weightedValues = entries.stream().filter(entry -> entry.shouldKeep(context)).map(entry -> new Pair(entry, (Object)entry.weight(context))).filter(pair -> (Double)pair.getSecond() > 0.0).toList();
        if (weightedValues.isEmpty()) {
            return CatchResult.empty();
        }
        if (testResults != null) {
            weightedValues.forEach(pair -> {
                if (entryTest.test((FishingEntry)pair.getFirst())) {
                    testResults.put((FishingEntry)pair.getFirst(), (Double)pair.getSecond());
                }
            });
        }
        double randomValue = context.rng().method_43058() * weightedValues.stream().mapToDouble(Pair::getSecond).sum();
        double cumulativeWeight = 0.0;
        for (Pair pair2 : weightedValues) {
            if (!(randomValue <= (cumulativeWeight += ((Double)pair2.getSecond()).doubleValue()))) continue;
            return ((FishingEntry)pair2.getFirst()).getResult(context, testResults, entryTest);
        }
        return CatchResult.empty();
    }
}

