/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loaders;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.li64.tide.Tide;
import com.li64.tide.data.ValidatableDataEntry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataLoader<T, R>
extends class_4080<R> {
    protected final String directory;
    protected R data;

    public AbstractDataLoader(String directory) {
        this.directory = directory;
    }

    public abstract void decode(class_2540 var1);

    public abstract void encode(class_2540 var1);

    protected abstract Codec<T> getEntryCodec();

    protected abstract int getEntryCount(R var1);

    protected abstract R prepareData(class_3300 var1, class_7654 var2);

    @NotNull
    protected R method_18789(@NotNull class_3300 manager, @NotNull class_3695 profiler) {
        class_7654 lister = class_7654.method_45114((String)this.directory);
        return this.prepareData(manager, lister);
    }

    protected void method_18788(@NotNull R data, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        this.setData(data);
        Tide.LOG.info("Loaded {} entries from '{}'", (Object)this.getEntryCount(data), (Object)this.getDirectory());
    }

    protected void parseOrLog(class_2960 key, Reader reader, Consumer<T> onSuccess) {
        JsonElement json = JsonParser.parseReader((Reader)reader);
        this.getEntryCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(error -> {
            if (Tide.CONFIG.general.logDataErrors) {
                Tide.LOG.error("Skipping invalid data entry '{}' due to parsing error: {}", (Object)key, error);
            }
        }).map(data -> {
            ValidatableDataEntry entry;
            if (data instanceof ValidatableDataEntry && !(entry = (ValidatableDataEntry)data).isValid()) {
                if (Tide.CONFIG.general.logDataErrors) {
                    Tide.LOG.error("Skipping invalid data entry '{}': {}", (Object)key, (Object)entry.invalidReason());
                }
                return null;
            }
            return data;
        }).ifPresent(onSuccess);
    }

    public class_2960 getDirectory() {
        return Tide.resource(this.directory);
    }

    public R get() {
        return this.data;
    }

    public void setData(R data) {
        this.data = data;
        this.onDataUpdated();
    }

    public void onDataUpdated() {
    }
}

