/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loaders;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.data.loaders.AbstractDataLoader;
import com.mojang.serialization.Codec;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7654;

public abstract class FlatDataLoader<T>
extends AbstractDataLoader<T, List<T>> {
    public FlatDataLoader(String directory) {
        super(directory);
    }

    public static <T> FlatDataLoader<T> of(String directory, final Codec<T> codec) {
        return new FlatDataLoader<T>(directory){

            @Override
            protected Codec<T> getEntryCodec() {
                return codec;
            }
        };
    }

    @Override
    public void decode(class_2540 buf) {
        ArrayList<Object> tempValues = new ArrayList<Object>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            tempValues.add(buf.method_49394(this.getEntryCodec()));
        }
        this.setData(ImmutableList.copyOf(tempValues));
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(((List)this.data).size());
        ((List)this.data).forEach(entry -> buf.method_49395(this.getEntryCodec(), entry));
    }

    @Override
    protected List<T> prepareData(class_3300 manager, class_7654 lister) {
        ArrayList output = new ArrayList();
        lister.method_45113(manager).forEach((path, resource) -> {
            try (BufferedReader reader = resource.method_43039();){
                this.parseOrLog((class_2960)path, reader, output::add);
            }
            catch (Exception e) {
                Tide.LOG.error("Failed to read '{}'", path, (Object)e);
            }
        });
        return output;
    }

    @Override
    protected int getEntryCount(List<T> data) {
        return data.size();
    }
}

