/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loaders;

import com.li64.tide.Tide;
import com.li64.tide.data.SendableDataMap;
import com.li64.tide.data.loaders.AbstractDataLoader;
import com.mojang.serialization.Codec;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;

public abstract class LayeredDataLoader<T>
extends AbstractDataLoader<T, SendableDataMap<T>> {
    public LayeredDataLoader(String directory) {
        super(directory);
    }

    public static <T> LayeredDataLoader<T> of(String directory, final Codec<T> codec) {
        return new LayeredDataLoader<T>(directory){

            @Override
            protected Codec<T> getEntryCodec() {
                return codec;
            }
        };
    }

    @Override
    public void decode(class_2540 buf) {
        this.setData(SendableDataMap.decode(buf, this.getEntryCodec()));
    }

    @Override
    public void encode(class_2540 buf) {
        ((SendableDataMap)this.data).encode(buf);
    }

    @Override
    protected SendableDataMap<T> prepareData(class_3300 manager, class_7654 lister) {
        HashMap collected = new HashMap();
        lister.method_45116(manager).forEach((path, resources) -> {
            class_2960 key = lister.method_45115(path);
            resources.forEach(resource -> {
                try (BufferedReader reader = resource.method_43039();){
                    this.parseOrLog((class_2960)path, reader, value -> collected.computeIfAbsent(key, k -> new ArrayList()).add(new SourcedValue<Object>(resource.method_14480(), value)));
                }
                catch (Exception e) {
                    Tide.LOG.error("Failed to read '{}'", path, (Object)e);
                }
            });
        });
        return new SendableDataMap<T>(this.mergeDuplicates(collected), this.getEntryCodec());
    }

    @Override
    protected int getEntryCount(SendableDataMap<T> data) {
        return data.count();
    }

    private Map<class_2960, T> mergeDuplicates(Map<class_2960, List<SourcedValue<T>>> input) {
        TreeMap output = new TreeMap();
        input.forEach((key, list) -> output.put(key, list.stream().sorted(Comparator.comparingInt(SourcedValue::loadOrder)).map(SourcedValue::value).reduce((a, b) -> b).orElseThrow()));
        return output;
    }

    protected record SourcedValue<T>(String sourcePackId, T value) {
        public int loadOrder() {
            if (this.sourcePackId.equals("tide")) {
                return -2;
            }
            if (this.sourcePackId.equals("minecraft")) {
                return -1;
            }
            return 0;
        }

        @Override
        @NotNull
        public String toString() {
            return "SourcedValue{sourcePackId='" + this.sourcePackId + "', value=" + String.valueOf(this.value) + "}";
        }
    }
}

