/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.minigame;

import com.li64.tide.Tide;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.fishing.mediums.FishingMedium;
import com.li64.tide.network.messages.MinigameClientMsg;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.util.TideUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class FishCatchMinigame {
    private static final int SERVER_DELAY_MILLIS = 200;
    private static final ArrayList<FishCatchMinigame> ACTIVE_MINIGAMES = new ArrayList();
    private static final HashMap<class_3222, Long> ACTIVE_DELAYS = new HashMap();
    private final TideFishingHook hook;
    private final class_3222 player;

    public static FishCatchMinigame getInstance(class_1657 player) {
        for (FishCatchMinigame minigame : ACTIVE_MINIGAMES) {
            if (minigame.getPlayer() != player) continue;
            return minigame;
        }
        return null;
    }

    public static FishCatchMinigame create(class_1657 player) {
        FishCatchMinigame existingInstance = FishCatchMinigame.getInstance(player);
        if (existingInstance != null) {
            return existingInstance;
        }
        FishCatchMinigame minigame = new FishCatchMinigame((class_3222)player);
        ACTIVE_MINIGAMES.add(minigame);
        return minigame;
    }

    public static boolean minigameActive(class_1657 player) {
        for (FishCatchMinigame minigame : ACTIVE_MINIGAMES) {
            if (minigame.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    protected FishCatchMinigame(class_3222 player) {
        this.player = player;
        this.hook = Objects.requireNonNull(HookAccessor.getHook((class_1657)player));
        this.hook.setMinigameActive(true);
        Optional<FishData> data = TideUtils.getStrongest(this.hook.getHookedItems());
        int behavior = data.map(d -> d.behavior().ordinal()).orElse(0);
        float fishStrength = data.map(FishData::strength).orElse(Float.valueOf(0.2f)).floatValue();
        float fishSpeed = data.map(FishData::speed).orElse(Float.valueOf(0.5f)).floatValue();
        if (this.hook.getHook().method_31574(TideItems.IRON_FISHING_HOOK)) {
            fishStrength *= 0.85f;
        }
        float area = class_3532.method_15363((float)(1.0f - fishStrength), (float)0.05f, (float)1.0f);
        float speed = Math.max(fishSpeed / 20.0f * Tide.CONFIG.minigame.minigameDifficulty, 0.05f);
        int type = 0;
        if (this.hook.getCurrentMedium() == FishingMedium.LAVA) {
            type = 1;
        }
        if (this.hook.getCurrentMedium() == FishingMedium.VOID) {
            type = 2;
        }
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(0, (byte)type, (byte)behavior, area, speed), player);
    }

    public static boolean delayActive(class_3222 player) {
        if (!ACTIVE_DELAYS.containsKey(player)) {
            return false;
        }
        if (System.currentTimeMillis() > ACTIVE_DELAYS.get(player)) {
            ACTIVE_DELAYS.remove(player);
            return false;
        }
        return true;
    }

    private class_3222 getPlayer() {
        return this.player;
    }

    public void onFinish() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.hook.setMinigameActive(false);
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(2), this.player);
        ACTIVE_MINIGAMES.remove(this);
        ACTIVE_DELAYS.put(this.player, System.currentTimeMillis() + 200L);
    }

    public void onTimeout() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.onFinish();
    }

    public void onFail() {
        if (this.cancelIfNecessary()) {
            return;
        }
        if (Tide.CONFIG.minigame.doFailSound) {
            this.hook.method_37908().method_8396(null, this.hook.getPlayerOwner().method_24515(), class_3417.field_14975, class_3419.field_15256, 0.9f, 1.0f);
        }
        this.hook.invalidateCatch();
        this.hook.retrieve();
        this.onFinish();
    }

    public void onWin(boolean perfectCatch) {
        if (this.cancelIfNecessary()) {
            return;
        }
        if (Tide.CONFIG.minigame.doSuccessSound) {
            this.hook.method_37908().method_8396(null, this.hook.getPlayerOwner().method_24515(), class_3417.field_14627, class_3419.field_15256, 0.15f, 1.0f);
        }
        this.hook.retrieve(perfectCatch);
        this.onFinish();
    }

    public boolean cancelIfNecessary() {
        if (this.hook == null || this.player == null) {
            Tide.NETWORK.sendToPlayer(new MinigameClientMsg(2), this.player);
            ACTIVE_MINIGAMES.remove(this);
            return true;
        }
        return false;
    }

    public void handleClientEvent(byte event) {
        this.cancelIfNecessary();
        switch (event) {
            case 0: {
                this.onTimeout();
                break;
            }
            case 1: {
                this.onFail();
                break;
            }
            case 2: {
                this.onWin(false);
                break;
            }
            case 3: {
                this.onWin(true);
            }
        }
    }
}

