/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.player;

import com.li64.tide.data.player.CatchTimestamp;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_5699;

public class FishStats {
    public static final Codec<FishStats> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("amount_caught").forGetter(FishStats::getAmountCaught), (App)CatchTimestamp.CODEC.optionalFieldOf("initial_catch_date").forGetter(FishStats::getInitialCatchDate), (App)Codec.DOUBLE.fieldOf("largest_catch").forGetter(FishStats::getLargestCatch), (App)Codec.DOUBLE.fieldOf("smallest_catch").forGetter(FishStats::getSmallestCatch)).apply((Applicative)instance, FishStats::new));
    private int amountCaught;
    private Optional<CatchTimestamp> initialCatchDate;
    private double largestCatch;
    private double smallestCatch;

    public FishStats() {
        this(0, Optional.empty(), 0.0, Double.POSITIVE_INFINITY);
    }

    public FishStats(int amountCaught, Optional<CatchTimestamp> initialCatchDate, double largestCatch, double smallestCatch) {
        this.amountCaught = amountCaught;
        this.initialCatchDate = initialCatchDate;
        this.largestCatch = largestCatch;
        this.smallestCatch = smallestCatch;
    }

    public int getAmountCaught() {
        return this.amountCaught;
    }

    public Optional<CatchTimestamp> getInitialCatchDate() {
        return this.initialCatchDate;
    }

    public double getLargestCatch() {
        return this.largestCatch;
    }

    public double getSmallestCatch() {
        return this.smallestCatch;
    }

    public boolean isEmpty() {
        return this.amountCaught == 0;
    }

    public void logCatch(CatchTimestamp timestamp, double size) {
        ++this.amountCaught;
        if (this.initialCatchDate.isEmpty()) {
            this.initialCatchDate = Optional.of(timestamp);
        }
        if (size <= 0.0 || size > this.largestCatch) {
            this.largestCatch = size;
        }
        if (size <= 0.0 || size < this.smallestCatch) {
            this.smallestCatch = size;
        }
    }
}

