/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.player;

import com.li64.tide.Tide;
import com.li64.tide.TideConfig;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideData;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.item.TideItemData;
import com.li64.tide.data.player.CatchTimestamp;
import com.li64.tide.data.player.FishStats;
import com.li64.tide.network.messages.SyncPlayerDataMsg;
import com.li64.tide.util.TideUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class TidePlayerData {
    public static TidePlayerData CLIENT_DATA = new TidePlayerData();
    private static final String NBT_TAG = "TidePlayerData";
    public boolean gotJournal;
    public Map<class_6880<class_1792>, FishPlayerData> fishPlayerData;

    public TidePlayerData() {
        this(new class_2487());
    }

    public TidePlayerData(class_2487 tag) {
        this.gotJournal = tag.method_10577("got_journal");
        class_2499 fishList = tag.method_10554("fish_data", 10);
        this.fishPlayerData = new HashMap<class_6880<class_1792>, FishPlayerData>(fishList.size());
        fishList.forEach(t -> {
            class_2487 fishTag;
            if (!(t instanceof class_2487) || !(fishTag = (class_2487)t).method_10545("fish")) {
                return;
            }
            class_6880 item = class_7923.field_41178.method_47983((Object)((class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)fishTag.method_10558("fish")))));
            this.fishPlayerData.put((class_6880<class_1792>)item, FishPlayerData.readFrom(fishTag, "data").orElse(new FishPlayerData()));
        });
    }

    public static TidePlayerData getOrCreate(class_3222 player) {
        return TidePlayerData.getOrCreate(Tide.PLATFORM.getPlayerData(player));
    }

    public static TidePlayerData getOrCreate(class_2487 tag) {
        if (!tag.method_10545(NBT_TAG)) {
            tag.method_10566(NBT_TAG, (class_2520)new class_2487());
        }
        return new TidePlayerData(tag.method_10562(NBT_TAG));
    }

    public class_2487 getAsTag() {
        class_2487 tag = new class_2487();
        class_2499 fishList = new class_2499();
        this.fishPlayerData.forEach((item, data) -> {
            class_2487 fishTag = new class_2487();
            fishTag.method_10582("fish", class_7923.field_41178.method_10221((Object)((class_1792)item.comp_349())).toString());
            data.saveTo(fishTag, "data");
            fishList.add((Object)fishTag);
        });
        tag.method_10566("fish_data", (class_2520)fishList);
        tag.method_10556("got_journal", this.gotJournal);
        return tag;
    }

    public void syncTo(class_3222 player) {
        class_2487 data = Tide.PLATFORM.getPlayerData(player);
        class_2487 playerData = this.getAsTag();
        data.method_10566(NBT_TAG, (class_2520)playerData);
        Tide.NETWORK.sendToPlayer(new SyncPlayerDataMsg(playerData), player);
    }

    public Optional<FishPlayerData> getDataFor(class_1792 item) {
        return Optional.ofNullable(this.fishPlayerData.get(class_7923.field_41178.method_47983((Object)item)));
    }

    public boolean isFishUnlocked(class_6880<class_1792> holder) {
        return Optional.ofNullable(this.fishPlayerData.get(holder)).map(data -> data.isUnlocked).orElse(false);
    }

    public boolean isFishUnlocked(class_1799 stack) {
        return this.fishPlayerData.entrySet().stream().filter(entry -> stack.method_41406((class_6880)entry.getKey())).anyMatch(entry -> ((FishPlayerData)entry.getValue()).isUnlocked);
    }

    public boolean unlockFish(class_6880<class_1792> fish, class_3222 player) {
        if (!this.fishPlayerData.containsKey(fish)) {
            this.fishPlayerData.put(fish, new FishPlayerData(true, true, Optional.empty()));
            this.checkJournalCompletion(player);
            return true;
        }
        FishPlayerData data = this.fishPlayerData.get(fish);
        if (data.isUnlocked) {
            return false;
        }
        data.isUnlocked = true;
        data.isUnread = true;
        return true;
    }

    public void markAsRead(class_1799 stack) {
        class_6880 fish = stack.method_41409();
        if (!this.fishPlayerData.containsKey(fish)) {
            return;
        }
        this.fishPlayerData.get((Object)fish).isUnread = false;
    }

    public boolean isUnread(class_1799 stack) {
        class_6880 fish = stack.method_41409();
        if (!this.fishPlayerData.containsKey(fish)) {
            return false;
        }
        return this.fishPlayerData.get((Object)fish).isUnlocked && this.fishPlayerData.get((Object)fish).isUnread;
    }

    public void logCatch(class_1799 stack, class_3222 player, class_1937 level) {
        FishPlayerData playerData;
        FishStats stats;
        FishData data = FishData.get(stack).orElse(null);
        if (data == null) {
            return;
        }
        class_6880<class_1792> fish = data.fish();
        if (this.unlockFish(fish, player)) {
            TideUtils.showFishToast(stack, player);
        }
        FishStats fishStats = stats = (playerData = this.fishPlayerData.get(fish)) == null ? new FishStats() : playerData.stats.orElse(new FishStats());
        if (data.size().isPresent()) {
            double fishLength = 0.0;
            if (TideItemData.FISH_LENGTH.isPresent(stack)) {
                fishLength = TideItemData.FISH_LENGTH.getOrDefault(stack, 0.0);
            } else if (Tide.CONFIG.items.fishItemSizes == TideConfig.Items.SizeMode.IN_JOURNAL) {
                fishLength = data.getRandomLength(level.field_9229);
            }
            stats.logCatch(CatchTimestamp.now(level), fishLength);
        }
        if (playerData == null) {
            this.fishPlayerData.put((class_6880<class_1792>)stack.method_41409(), new FishPlayerData(stats));
        } else {
            this.fishPlayerData.get(fish).stats = Optional.of(stats);
        }
    }

    private void checkJournalCompletion(class_3222 player) {
        int total;
        int amountCompleted = this.fishPlayerData.size();
        float ratio = (float)amountCompleted / (float)(total = TideData.FISH.journalEntryCount());
        if (ratio >= 0.5f) {
            TideCriteriaTriggers.JOURNAL_HALFWAY_COMPLETE.trigger(player);
        }
        if (ratio >= 1.0f) {
            TideCriteriaTriggers.JOURNAL_COMPLETE.trigger(player);
        }
    }

    public static class FishPlayerData {
        public static final Codec<FishPlayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("is_unlocked").forGetter(data -> data.isUnlocked), (App)Codec.BOOL.fieldOf("is_unread").forGetter(data -> data.isUnread), (App)FishStats.CODEC.optionalFieldOf("stats").forGetter(data -> data.stats)).apply((Applicative)instance, FishPlayerData::new));
        public boolean isUnlocked;
        public boolean isUnread;
        public Optional<FishStats> stats;

        public FishPlayerData() {
            this(false, false, Optional.empty());
        }

        public FishPlayerData(FishStats stats) {
            this(false, false, Optional.of(stats));
        }

        public FishPlayerData(boolean isUnlocked, boolean isUnread, Optional<FishStats> stats) {
            this.isUnlocked = isUnlocked;
            this.isUnread = isUnread;
            this.stats = stats;
        }

        public void saveTo(class_2487 tag, String key) {
            tag.method_10566(key, (class_2520)CODEC.encode((Object)this, (DynamicOps)class_2509.field_11560, (Object)new class_2487()).result().orElseThrow());
        }

        public static Optional<FishPlayerData> readFrom(class_2487 tag, String key) {
            try {
                return CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(key)).result().map(Pair::getFirst);
            }
            catch (Exception e) {
                Tide.LOG.error("Error reading fish player data! Journal data may be lost.", (Throwable)e);
                return Optional.empty();
            }
        }
    }
}

