/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.google.common.collect.ImmutableList;
import com.li64.tide.data.ItemDataKey;
import com.li64.tide.data.item.TideItemData;
import com.li64.tide.registries.TideItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class CustomRodManager {
    private static final class_1799 DEFAULT_BOBBER = TideItems.RED_FISHING_BOBBER.method_7854();
    private static final class_1799 DEFAULT_HOOK = TideItems.FISHING_HOOK.method_7854();
    private static final class_1799 DEFAULT_LINE = TideItems.FISHING_LINE.method_7854();

    public static void setBobber(class_1799 rod, class_1799 bobber) {
        CustomRodManager.setAccessory(TideItemData.FISHING_BOBBER, rod, bobber);
    }

    public static void setHook(class_1799 rod, class_1799 hook) {
        CustomRodManager.setAccessory(TideItemData.FISHING_HOOK, rod, hook);
    }

    public static void setLine(class_1799 rod, class_1799 line) {
        CustomRodManager.setAccessory(TideItemData.FISHING_LINE, rod, line);
    }

    private static void setAccessory(ItemDataKey<class_2487> dataKey, class_1799 rod, class_1799 accessory) {
        if (accessory == null || accessory.method_7960()) {
            dataKey.set(rod, new class_2487());
            return;
        }
        dataKey.set(rod, accessory.method_7953(new class_2487()));
    }

    public static class_1799 getBobber(class_1799 rod) {
        return CustomRodManager.getAccessory(TideItemData.FISHING_BOBBER, rod, DEFAULT_BOBBER);
    }

    public static class_1799 getHook(class_1799 rod) {
        return CustomRodManager.getAccessory(TideItemData.FISHING_HOOK, rod, DEFAULT_HOOK);
    }

    public static class_1799 getLine(class_1799 rod) {
        return CustomRodManager.getAccessory(TideItemData.FISHING_LINE, rod, DEFAULT_LINE);
    }

    public static boolean hasBobber(class_1799 rod) {
        return CustomRodManager.getAccessory(TideItemData.FISHING_BOBBER, rod) != null;
    }

    public static boolean hasHook(class_1799 rod) {
        return CustomRodManager.getAccessory(TideItemData.FISHING_HOOK, rod) != null;
    }

    public static boolean hasLine(class_1799 rod) {
        return CustomRodManager.getAccessory(TideItemData.FISHING_LINE, rod) != null;
    }

    private static class_1799 getAccessory(ItemDataKey<class_2487> dataKey, class_1799 rod) {
        return CustomRodManager.getAccessory(dataKey, rod, null);
    }

    private static class_1799 getAccessory(ItemDataKey<class_2487> dataKey, class_1799 rod, class_1799 defaultItem) {
        class_2487 data = dataKey.get(rod);
        if (data == null || data.method_33133()) {
            return defaultItem;
        }
        Optional<class_1799> accessory = Optional.of(class_1799.method_7915((class_2487)data)).map(s -> s.method_7960() ? null : s);
        return accessory.orElse(defaultItem);
    }

    public static List<class_1799> getAccessoryList(class_1799 stack) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (CustomRodManager.hasBobber(stack)) {
            builder.add((Object)CustomRodManager.getBobber(stack));
        }
        if (CustomRodManager.hasHook(stack)) {
            builder.add((Object)CustomRodManager.getHook(stack));
        }
        if (CustomRodManager.hasLine(stack)) {
            builder.add((Object)CustomRodManager.getLine(stack));
        }
        return builder.build();
    }
}

