/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.datagen.fabric.providers.fishing;

import com.li64.tide.compat.fishofthieves.FishOfThievesFishData;
import com.li64.tide.compat.hybridaquatic.HybridAquaticFishData;
import com.li64.tide.compat.netherdepths.NetherDepthsFishData;
import com.li64.tide.compat.seasons.Season;
import com.li64.tide.compat.stardewfishing.StardewFishingFishData;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.journal.FishRarity;
import com.li64.tide.data.journal.JournalGroup;
import com.li64.tide.datagen.fabric.providers.SimpleDataOutput;
import com.li64.tide.datagen.fabric.providers.SimpleDataProvider;
import com.li64.tide.registries.TideFish;
import com.mojang.serialization.Codec;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class TideFishDataProvider
extends SimpleDataProvider<FishData> {
    public TideFishDataProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
        super("fishing/fish", output, registries);
    }

    @Override
    protected Codec<FishData> dataCodec() {
        return FishData.CODEC;
    }

    @Override
    protected void generate(SimpleDataOutput<FishData> output) {
        TideFish.DATA_BUILDERS.forEach((item, constructor) -> {
            FishData.Builder builder = FishData.builder();
            constructor.accept(builder.fish((class_1792)item));
            class_2960 itemKey = class_7923.field_41178.method_10221(item);
            if (TideFish.ENTITY_DATA.containsKey(itemKey.method_12832())) {
                builder.bucket((class_1792)class_7923.field_41178.method_10223(itemKey.method_48331("_bucket")));
            }
            builder.build(output);
        });
        FishData.builder().fish(class_1802.field_8209).bucket(class_1802.field_8714).size(55.0, 95.0, 145.0).strength(0.4f).speed(0.9f).selectionWeight(40.0).temperature(-0.6f, 1.1f).seasons(Season.SUMMER, Season.FALL, Season.WINTER).overworld().water().surface().freshwater().journalLocation("journal.info.location.freshwater").journalGroup(JournalGroup.FRESHWATER).displayData(display -> display.offsets(0.1f, -0.1f, 0.0f).rotation(0.0f, 0.0f, 0.0f)).build(output);
        FishData.builder().fish(class_1802.field_8429).bucket(class_1802.field_8666).size(65.0, 115.0, 200.0).strength(0.5f).speed(1.0f).selectionWeight(55.0).temperature(-1.0f, 1.3f).overworld().water().surface().saltwater().journalLocation("journal.info.location.saltwater").journalGroup(JournalGroup.SALTWATER).displayData(display -> display.offsets(0.1f, 0.0f, 0.0f).rotation(0.0f, 0.0f, 0.0f)).build(output);
        FishData.builder().fish(class_1802.field_8323).bucket(class_1802.field_8108).size(12.0, 22.0, 75.0).strength(0.6f).speed(1.25f).selectionWeight(25.0).temperature(1.0f, 0.8f).overworld().water().surface().saltwater().journalLocation("journal.info.location.saltwater").journalGroup(JournalGroup.SALTWATER).journalRarity(FishRarity.UNCOMMON).displayData(display -> display.offsets(0.05f, 0.0f, -0.1f).rotation(0.0f, 0.0f, 0.0f)).build(output);
        FishData.builder().fish(class_1802.field_8846).bucket(class_1802.field_8478).size(10.0, 35.0, 100.0).strength(0.4f).speed(1.1f).selectionWeight(50.0).temperature(1.0f, 0.8f).overworld().water().surface().saltwater().journalLocation("journal.info.location.saltwater").journalGroup(JournalGroup.SALTWATER).displayData(display -> display.offsets(0.05f, -0.08f, 0.0f).rotation(0.0f, 0.0f, 0.0f)).build(output);
        NetherDepthsFishData.generate(output);
        HybridAquaticFishData.generate(output);
        StardewFishingFishData.generate(output);
        FishOfThievesFishData.generate(output);
    }

    @NotNull
    public String method_10321() {
        return "Fish Data";
    }
}

