/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.datagen.fabric.providers.fishing;

import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.fishing.FishingLootData;
import com.li64.tide.data.fishing.conditions.types.BlockNearbyCondition;
import com.li64.tide.data.fishing.conditions.types.StructuresCondition;
import com.li64.tide.datagen.fabric.providers.SimpleDataOutput;
import com.li64.tide.datagen.fabric.providers.SimpleDataProvider;
import com.mojang.serialization.Codec;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3195;
import net.minecraft.class_39;
import net.minecraft.class_5321;
import net.minecraft.class_7058;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class TideFishingLootDataProvider
extends SimpleDataProvider<FishingLootData> {
    public TideFishingLootDataProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
        super("fishing/loot", output, registries);
    }

    @Override
    protected Codec<FishingLootData> dataCodec() {
        return FishingLootData.CODEC;
    }

    @Override
    protected void generate(SimpleDataOutput<FishingLootData> output) {
        FishingLootData.builder().lootTable(class_39.field_854).selectionWeight(5.0).selectionQuality(2.0).openWater(true).overworld().water().surface().build("surface_treasure", output);
        FishingLootData.builder().lootTable(TideLootTables.Fishing.TREASURE_UNDERGROUND).selectionWeight(5.0).selectionQuality(2.0).overworld().water().below(41).build("underground_treasure", output);
        FishingLootData.builder().lootTable(TideLootTables.Fishing.TREASURE_NETHER).selectionWeight(0.8).selectionQuality(0.5).nether().build("nether_treasure", output);
        FishingLootData.builder().lootTable(class_39.field_266).selectionWeight(10.0).selectionQuality(-2.0).overworld().water().surface().build("surface_junk", output);
        FishingLootData.builder().lootTable(TideLootTables.Fishing.JUNK_UNDERGROUND).selectionWeight(12.0).selectionQuality(-2.0).overworld().water().below(41).build("underground_junk", output);
        FishingLootData.builder().lootTable(TideLootTables.Fishing.JUNK_LAVA).selectionWeight(30.0).selectionQuality(-1.0).lava().build("lava_junk", output);
        FishingLootData.builder().lootTable(TideLootTables.Fishing.OCEAN_MONUMENT_TREASURE).selectionWeight(20.0).selectionQuality(1.0).condition(StructuresCondition.only((class_5321<class_3195>)class_7058.field_37179)).build("ocean_monument_treasure", output);
        FishingLootData.builder().lootTable(TideLootTables.Fishing.DESERT_WELL_TREASURE).selectionWeight(30.0).selectionQuality(1.0).condition(BlockNearbyCondition.inRadius(TideTags.Blocks.DESERT_WELL_LOOT, 3)).build("desert_well_treasure", output);
    }

    @NotNull
    public String method_10321() {
        return "Fishing Loot Data";
    }
}

