/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.fish;

import com.li64.tide.compat.seasons.SeasonsCompat;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.conditions.FishingConditionType;
import com.li64.tide.data.fishing.mediums.FishingMedium;
import com.li64.tide.data.fishing.mediums.VoidMedium;
import com.li64.tide.util.TideUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1425;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TideFishEntity
extends class_1425 {
    private final class_1792 bucketItem;

    public TideFishEntity(class_1299<? extends class_1425> entityType, class_1937 level) {
        super(entityType, level);
        class_2960 key = class_7923.field_41177.method_10221(entityType);
        this.bucketItem = (class_1792)class_7923.field_41178.method_17966(key.method_48331("_bucket")).orElseThrow();
    }

    @NotNull
    protected class_3414 method_6457() {
        return class_3417.field_14918;
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return class_3417.field_14851;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15003;
    }

    @NotNull
    public class_1799 method_6452() {
        return this.bucketItem.method_7854();
    }

    @NotNull
    public class_1425 method_6461(class_1425 leader) {
        if (leader.method_5864() == this.method_5864()) {
            return super.method_6461(leader);
        }
        return this;
    }

    public static <T extends class_1308> boolean checkWaterFishSpawnRules(class_1299<T> entityType, class_5425 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        if (pos.method_10264() > level.method_8615() || !level.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) || !level.method_8320(pos.method_10084()).method_27852(class_2246.field_10382)) {
            return false;
        }
        return TideFishEntity.checkTideFishSpawnRules(entityType, level, pos, random, FishingMedium.WATER);
    }

    public static <T extends class_1308> boolean checkLavaFishSpawnRules(class_1299<T> entityType, class_5425 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        if (pos.method_10264() > level.method_8615() || !level.method_8316(pos.method_10074()).method_15767(class_3486.field_15518) || !level.method_8320(pos.method_10084()).method_27852(class_2246.field_10164)) {
            return false;
        }
        return TideFishEntity.checkTideFishSpawnRules(entityType, level, pos, random, FishingMedium.LAVA);
    }

    public static <T extends class_1308> boolean checkVoidFishSpawnRules(class_1299<T> entityType, class_5425 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        if (pos.method_10264() > VoidMedium.VOID.getVoidSurface((class_1937)level.method_8410()) || !level.method_8320(pos).method_26215()) {
            return false;
        }
        return TideFishEntity.checkTideFishSpawnRules(entityType, level, pos, random, FishingMedium.VOID);
    }

    public static <T extends class_1308> boolean checkTideFishSpawnRules(class_1299<T> entityType, class_5425 level, class_2338 pos, class_5819 random, FishingMedium medium) {
        FishData data = FishData.get(entityType).orElseThrow();
        class_6880<class_1959> biome = level.method_23753(pos);
        class_6880<class_1959> nearestBiome = data.conditions().stream().anyMatch(c -> c.type() == FishingConditionType.BIOME_WHITELIST) ? TideUtils.findClosestNonWaterBiome((class_1937)level.method_8410(), pos, 12, 3).orElse(biome) : biome;
        FishingContext context = new FishingContext(level.method_8410(), null, random, pos.method_46558(), pos, 0, medium.id().method_12832(), class_1799.field_8037, biome, nearestBiome, (class_5321<class_1937>)level.method_8410().method_27983(), TideUtils.getTemperatureAt(pos, level.method_8410()), level.method_30273(), SeasonsCompat.getSeason((class_1937)level.method_8410()));
        boolean conditionsMatch = data.shouldKeep(context);
        boolean nonzeroWeight = data.weight(context) / data.weight() > 0.1;
        return conditionsMatch && nonzeroWeight;
    }
}

