/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.fish.lava;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.class_10;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4459;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LavaSwimNodeEvaluator
extends class_8 {
    private final boolean allowBreaching;
    private final Long2ObjectMap<class_7> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public LavaSwimNodeEvaluator(boolean allowBreaching) {
        this.allowBreaching = allowBreaching;
    }

    public void method_12(@NotNull class_1950 region, @NotNull class_1308 mob) {
        super.method_12(region, mob);
        this.pathTypesByPosCache.clear();
    }

    public void method_19() {
        super.method_19();
        this.pathTypesByPosCache.clear();
    }

    @NotNull
    public class_9 method_21() {
        return this.method_13(class_3532.method_15357((double)this.field_33.method_5829().field_1323), class_3532.method_15357((double)(this.field_33.method_5829().field_1322 + 0.5)), class_3532.method_15357((double)this.field_33.method_5829().field_1321));
    }

    protected boolean isNodeValid(@Nullable class_9 node) {
        return node != null && !node.field_42;
    }

    private static boolean hasMalus(@Nullable class_9 node) {
        return node != null && node.field_43 >= 0.0f;
    }

    public int method_18(class_9 @NotNull [] arr, @NotNull class_9 node) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            class_9 node1 = this.findAcceptedNode(node.field_40 + direction.method_10148(), node.field_39 + direction.method_10164(), node.field_38 + direction.method_10165());
            map.put(direction, node1);
            if (!this.isNodeValid(node1)) continue;
            arr[i++] = node1;
        }
        for (class_2350 direction1 : class_2350.class_2353.field_11062) {
            class_9 node1;
            class_2350 direction2 = direction1.method_10170();
            if (!LavaSwimNodeEvaluator.hasMalus((class_9)map.get(direction1)) || !LavaSwimNodeEvaluator.hasMalus((class_9)map.get(direction2)) || !this.isNodeValid(node1 = this.findAcceptedNode(node.field_40 + direction1.method_10148() + direction2.method_10148(), node.field_39, node.field_38 + direction1.method_10165() + direction2.method_10165()))) continue;
            arr[i++] = node1;
        }
        return i;
    }

    @NotNull
    public class_4459 method_16(double x, double y, double z) {
        return this.method_43568(this.method_13(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z)));
    }

    @Nullable
    protected class_9 findAcceptedNode(int x, int y, int z) {
        float f;
        class_9 node = null;
        class_7 pathType = this.getCachedBlockType(x, y, z);
        if ((this.allowBreaching && pathType == class_7.field_16 || pathType == class_7.field_18 || pathType == class_7.field_14) && (f = this.field_33.method_5944(pathType)) >= 0.0f) {
            node = this.method_13(x, y, z);
            node.field_41 = pathType;
            node.field_43 = Math.max(node.field_43, f);
            if (this.field_20622.method_8316(new class_2338(x, y, z)).method_15769()) {
                node.field_43 += 8.0f;
            }
        }
        return node;
    }

    protected class_7 getCachedBlockType(int x, int y, int z) {
        return (class_7)this.pathTypesByPosCache.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), l -> this.method_17((class_1922)this.field_20622, x, y, z));
    }

    @NotNull
    public class_7 method_17(class_1922 level, int i, int j, int k) {
        return this.method_25(level, i, j, k, this.field_33);
    }

    @NotNull
    public class_7 method_25(class_1922 level, int x, int y, int z, @NotNull class_1308 mob) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        class_2680 blockState = level.method_8320((class_2338)mutablePos.method_10103(x, y, z));
        class_3610 fluidState = blockState.method_26227();
        if (fluidState.method_15769() && blockState.method_26171(level, mutablePos.method_10074(), class_10.field_48) && blockState.method_26215()) {
            return class_7.field_16;
        }
        return fluidState.method_15767(class_3486.field_15518) ? class_7.field_18 : class_7.field_22;
    }
}

