/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.fish.lava;

import com.li64.tide.data.FishLengthHolder;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.registries.entities.fish.lava.LavaAnimal;
import com.li64.tide.registries.entities.fish.lava.LavaBoundPathNavigation;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1374;
import net.minecraft.class_1379;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5532;
import net.minecraft.class_5761;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TideLavaFish
extends LavaAnimal
implements class_5761,
FishLengthHolder {
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(TideLavaFish.class, (class_2941)class_2943.field_13323);
    private final class_1792 bucketItem;
    private double length;

    public TideLavaFish(class_1299<? extends LavaAnimal> entityType, class_1937 level) {
        super(entityType, level);
        class_2960 key = class_7923.field_41177.method_10221(entityType);
        class_1792 fishItem = (class_1792)class_7923.field_41178.method_17966(key).orElseThrow();
        this.bucketItem = (class_1792)class_7923.field_41178.method_17966(key.method_48331("_bucket")).orElseThrow();
        this.length = FishData.get(fishItem).map(data -> data.getRandomLength(this.method_6051())).orElse(0.0);
        this.field_6207 = new LavaFishMoveControl(this);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new LavaFishSwimGoal(this));
    }

    public void method_6091(@NotNull class_243 movement) {
        if (this.method_6034() && this.method_5771()) {
            this.method_5724(this.method_6029() / 50.0f, movement);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
        } else {
            super.method_6091(movement);
        }
    }

    public boolean isInLiquid() {
        return this.method_5816() || this.method_5771();
    }

    public void method_6007() {
        if (this.method_5799()) {
            this.method_5643(this.method_48923().method_48836(), 4.0f);
        }
        if (!this.isInLiquid() && this.method_24828() && this.field_5992) {
            this.method_18799(this.method_18798().method_1031(((double)this.field_5974.method_43057() * 2.0 - 1.0) * 0.05, 0.4, ((double)this.field_5974.method_43057() * 2.0 - 1.0) * 0.05));
            this.method_24830(false);
            this.field_6007 = true;
            this.method_5783(this.getFlopSound(), this.method_6107(), this.method_6017());
        }
        super.method_6007();
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new LavaBoundPathNavigation((class_1308)this, level);
    }

    protected boolean canRandomSwim() {
        return true;
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 source) {
        return class_3417.field_14851;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15003;
    }

    @Nullable
    protected class_3414 getFlopSound() {
        return class_3417.field_14918;
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        return TideLavaFish.lavaBucketMobPickup(player, hand, this).orElse(super.method_5992(player, hand));
    }

    @NotNull
    public class_1799 method_6452() {
        return this.bucketItem.method_7854();
    }

    @NotNull
    public class_3414 method_35171() {
        return class_3417.field_15202;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FROM_BUCKET, (Object)false);
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("FromBucket", this.method_6453());
        compound.method_10549("FishLength", this.length);
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.method_6454(tag.method_10545("FromBucket") && tag.method_10577("FromBucket"));
        this.length = tag.method_10545("FishLength") ? tag.method_10574("FishLength") : this.length;
    }

    public void method_6455(@NotNull class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        class_2487 tag = stack.method_7948();
        tag.method_10549("FishLength", this.tide$getLength());
    }

    public void method_35170(@NotNull class_2487 tag) {
        class_5761.method_35168((class_1308)this, (class_2487)tag);
        this.length = tag.method_10545("FishLength") ? tag.method_10574("FishLength") : this.length;
    }

    @Override
    public double tide$getLength() {
        return this.length;
    }

    @Override
    public void tide$setLength(double length) {
        this.length = length;
    }

    public static <T extends class_1309> Optional<class_1269> lavaBucketMobPickup(class_1657 player, class_1268 hand, T entity) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31573(TideTags.Items.LAVA_BUCKETS) && entity.method_5805()) {
            class_1799 filledBucket = ((class_5761)entity).method_6452();
            ((class_5761)entity).method_6455(filledBucket);
            player.method_6122(hand, class_5328.method_30270((class_1799)stack, (class_1657)player, (class_1799)filledBucket, (boolean)false));
            if (!entity.method_37908().field_9236) {
                class_174.field_1208.method_8932((class_3222)player, filledBucket);
            }
            entity.method_5783(((class_5761)entity).method_35171(), 1.0f, 1.0f);
            entity.method_31472();
            return Optional.of(class_1269.field_5812);
        }
        return Optional.empty();
    }

    static class LavaFishMoveControl
    extends class_1335 {
        private final TideLavaFish fish;

        public LavaFishMoveControl(TideLavaFish fish) {
            super((class_1308)fish);
            this.fish = fish;
        }

        public void method_6240() {
            if (this.fish.method_5777(class_3486.field_15518)) {
                this.fish.method_18799(this.fish.method_18798().method_1031(0.0, 0.005, 0.0));
            }
            if (this.field_6374 == class_1335.class_1336.field_6378 && !this.fish.method_5942().method_6357()) {
                float f = (float)(this.field_6372 * this.fish.method_26825(class_5134.field_23719));
                this.fish.method_6125(class_3532.method_16439((float)0.125f, (float)this.fish.method_6029(), (float)f));
                double d0 = this.field_6370 - this.fish.method_23317();
                double d1 = this.field_6369 - this.fish.method_23318();
                double d2 = this.field_6367 - this.fish.method_23321();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.fish.method_18799(this.fish.method_18798().method_1031(0.0, (double)this.fish.method_6029() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(class_3532.method_15349((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f;
                    this.fish.method_36456(this.method_6238(this.fish.method_36454(), f1, 90.0f));
                    this.fish.field_6283 = this.fish.method_36454();
                }
            } else {
                this.fish.method_6125(0.0f);
            }
        }
    }

    static class LavaFishSwimGoal
    extends class_1379 {
        public LavaFishSwimGoal(TideLavaFish fish) {
            this(fish, 1.0, 40);
        }

        public LavaFishSwimGoal(TideLavaFish fish, double speedModifier, int interval) {
            super((class_1314)fish, speedModifier, interval);
        }

        public boolean method_6264() {
            if (!this.field_6566.method_5771() || this.field_6566.method_5765() || this.field_6566.method_5968() != null) {
                return false;
            }
            if (!this.field_6565 && this.field_6566.method_6051().method_43048(this.field_6564) >= 100) {
                return false;
            }
            if (!((TideLavaFish)this.field_6566).canRandomSwim()) {
                return false;
            }
            class_243 pos = this.method_6302();
            if (pos == null) {
                return false;
            }
            this.field_6563 = pos.field_1352;
            this.field_6562 = pos.field_1351;
            this.field_6561 = pos.field_1350;
            this.field_6565 = false;
            return true;
        }

        protected class_243 method_6302() {
            class_243 pos = class_5532.method_31510((class_1314)this.field_6566, (int)10, (int)7);
            for (int i = 0; pos != null && !this.field_6566.method_37908().method_8316(class_2338.method_49638((class_2374)pos)).method_15767(class_3486.field_15518) && i < 9; ++i) {
                pos = class_5532.method_31510((class_1314)this.field_6566, (int)10, (int)7);
            }
            return pos;
        }
    }
}

