/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.fish.lava;

import com.li64.tide.registries.entities.fish.lava.TideLavaFish;
import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class TideSchoolingLavaFish
extends TideLavaFish {
    private TideSchoolingLavaFish leader;
    private int schoolSize = 1;

    public TideSchoolingLavaFish(class_1299<? extends TideSchoolingLavaFish> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(5, (class_1352)new FollowFlockLeaderGoal(this));
    }

    public int method_5945() {
        return this.getMaxSchoolSize();
    }

    public int getMaxSchoolSize() {
        return super.method_5945();
    }

    @Override
    protected boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.method_5805();
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public void startFollowing(TideSchoolingLavaFish leader) {
        if (this.hasFollowers() || leader.method_5864() != this.method_5864()) {
            return;
        }
        this.leader = leader;
        leader.addFollower();
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public void method_5773() {
        List list;
        super.method_5773();
        if (this.hasFollowers() && this.method_37908().field_9229.method_43048(200) == 1 && (list = this.method_37908().method_18467(this.getClass(), this.method_5829().method_1009(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
    }

    public boolean inRangeOfLeader() {
        return this.method_5858((class_1297)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.method_5942().method_6335((class_1297)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends TideSchoolingLavaFish> followers) {
        followers.limit(this.getMaxSchoolSize() - this.schoolSize).filter(f -> f != this).forEach(f -> f.startFollowing(this));
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 groupData, @Nullable class_2487 tag) {
        super.method_5943(level, difficulty, spawnType, groupData, tag);
        if (groupData == null) {
            groupData = new SchoolSpawnGroupData(this);
        } else {
            this.startFollowing(((SchoolSpawnGroupData)groupData).leader);
        }
        return groupData;
    }

    static class FollowFlockLeaderGoal
    extends class_1352 {
        private final TideSchoolingLavaFish mob;
        private int timeToRecalcPath;
        private int nextStartTick;

        public FollowFlockLeaderGoal(TideSchoolingLavaFish fish) {
            this.mob = fish;
            this.nextStartTick = this.nextStartTick(fish);
        }

        protected int nextStartTick(TideSchoolingLavaFish taskOwner) {
            return FollowFlockLeaderGoal.method_38848((int)(200 + taskOwner.method_6051().method_43048(200) % 20));
        }

        public boolean method_6264() {
            if (this.mob.hasFollowers()) {
                return false;
            }
            if (this.mob.isFollower()) {
                return true;
            }
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick(this.mob);
            Predicate<TideSchoolingLavaFish> predicate = other -> other.canBeFollowed() || !other.isFollower();
            List nearbyFish = this.mob.method_37908().method_8390(this.mob.getClass(), this.mob.method_5829().method_1009(8.0, 8.0, 8.0), predicate);
            TideSchoolingLavaFish leader = (TideSchoolingLavaFish)DataFixUtils.orElse(nearbyFish.stream().filter(TideSchoolingLavaFish::canBeFollowed).findAny(), (Object)this.mob);
            leader.addFollowers(nearbyFish.stream().filter(other -> !other.isFollower() && other != this.mob));
            return this.mob.isFollower();
        }

        public boolean method_6266() {
            return this.mob.isFollower() && this.mob.inRangeOfLeader();
        }

        public void method_6269() {
            this.timeToRecalcPath = 0;
        }

        public void method_6270() {
            this.mob.stopFollowing();
        }

        public void method_6268() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.method_38847(10);
                this.mob.pathToLeader();
            }
        }
    }

    public record SchoolSpawnGroupData(TideSchoolingLavaFish leader) implements class_1315
    {
    }
}

