/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.compat.CompatHelper;
import com.li64.tide.compat.seasons.SeasonsCompat;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.fishing.CatchResult;
import com.li64.tide.data.fishing.CrateData;
import com.li64.tide.data.fishing.FishingContext;
import com.li64.tide.data.fishing.mediums.FishingMedium;
import com.li64.tide.data.fishing.selector.FishingEntry;
import com.li64.tide.data.item.TideItemData;
import com.li64.tide.data.loot.LootTableRef;
import com.li64.tide.data.rods.BaitContents;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.LootCrateEntity;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.items.TideFishingRodItem;
import com.li64.tide.util.BaitUtils;
import com.li64.tide.util.TideUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_39;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TideFishingHook
extends class_1676 {
    private final class_5819 syncedRandom = class_5819.method_43047();
    private boolean biting;
    private int outOfWaterTime;
    private static final class_2940<Integer> DATA_HOOKED_ENTITY = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_BITING = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_1799> DATA_ROD_ITEM = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> DATA_CATCH_TYPE = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_MINIGAME_ACTIVE = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> DATA_INITIAL_YAW = class_2945.method_12791(TideFishingHook.class, (class_2941)class_2943.field_13320);
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    private class_1297 hookedIn;
    private FishHookState currentState = FishHookState.FLYING;
    private FishingMedium medium;
    private class_3610 fluidState = class_3612.field_15906.method_15785();
    private final int luck;
    private final int lureSpeed;
    private boolean minigameActive = false;
    protected class_1799 rod;
    protected List<class_1799> hookedItems;
    protected CatchType catchType = CatchType.NOTHING;
    private CrateData crateData;
    private int particleTimer = 0;
    private boolean wasPerfectCatch;

    private TideFishingHook(class_1299<? extends TideFishingHook> entityType, class_1937 level, int luck, int lureSpeed, class_1799 rod) {
        super(entityType, level);
        this.rod = rod;
        this.field_6011.method_12778(DATA_ROD_ITEM, (Object)rod);
        this.luck = Math.max(0, luck + (this.getLine().method_31574(TideItems.GOLDEN_LINE) ? 1 : 0));
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public TideFishingHook(class_1299<? extends TideFishingHook> entityType, class_1937 level) {
        this(entityType, level, 0, 0, class_1802.field_8378.method_7854());
    }

    public TideFishingHook(class_1299<? extends TideFishingHook> hookType, class_1657 player, class_1937 level, int luck, int lureSpeed, float charge, class_1799 rod) {
        this(hookType, level, luck, lureSpeed, rod);
        this.method_7432((class_1297)player);
        float f = player.method_36455();
        float f1 = player.method_36454();
        float f2 = class_3532.method_15362((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = class_3532.method_15374((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float f5 = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.method_23317() - (double)f3 * 0.3;
        double d1 = player.method_23320();
        double d2 = player.method_23321() - (double)f2 * 0.3;
        this.method_5808(d0, d1, d2, f1, f);
        class_243 vec3 = new class_243((double)(-f3), (double)class_3532.method_15363((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.method_1033();
        vec3 = vec3.method_18805((double)charge, (double)charge, (double)charge);
        vec3 = vec3.method_18805(0.6 / d3 + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / d3 + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / d3 + this.field_5974.method_43385(0.5, 0.0103365));
        this.method_18799(vec3);
        this.method_36456(f1);
        this.method_36457(0.0f);
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.field_6011.method_12778(DATA_INITIAL_YAW, (Object)Float.valueOf(f1));
        this.field_6011.method_12778(DATA_ROD_ITEM, (Object)rod);
    }

    public void invalidateCatch() {
        this.hookedItems = null;
        this.catchType = CatchType.NOTHING;
        this.method_5841().method_12778(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
    }

    public int getLureSpeed() {
        return this.lureSpeed;
    }

    public int getLuck() {
        return this.luck;
    }

    public float getInitialYaw() {
        return ((Float)this.field_6011.method_12789(DATA_INITIAL_YAW)).floatValue();
    }

    public class_6880<class_1959> getBiome() {
        return this.method_37908().method_23753(this.method_24515());
    }

    public class_3610 getFluidState() {
        return this.fluidState;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    protected void method_5693() {
        this.field_6011.method_12784(DATA_HOOKED_ENTITY, (Object)0);
        this.field_6011.method_12784(DATA_BITING, (Object)false);
        this.field_6011.method_12784(DATA_ROD_ITEM, (Object)class_1802.field_8378.method_7854());
        this.field_6011.method_12784(DATA_CATCH_TYPE, (Object)CatchType.NOTHING.ordinal());
        this.field_6011.method_12784(DATA_MINIGAME_ACTIVE, (Object)false);
        this.field_6011.method_12784(DATA_INITIAL_YAW, (Object)Float.valueOf(0.0f));
    }

    public void method_5674(@NotNull class_2940<?> data) {
        if (DATA_HOOKED_ENTITY.equals(data)) {
            int i = (Integer)this.method_5841().method_12789(DATA_HOOKED_ENTITY);
            class_1297 class_12972 = this.hookedIn = i > 0 ? this.method_37908().method_8469(i - 1) : null;
        }
        if (DATA_BITING.equals(data)) {
            this.biting = (Boolean)this.method_5841().method_12789(DATA_BITING);
            if (this.biting) {
                this.method_18800(this.method_18798().field_1352, -0.4f * class_3532.method_15344((class_5819)this.syncedRandom, (float)0.6f, (float)1.0f), this.method_18798().field_1350);
            }
        }
        if (DATA_ROD_ITEM.equals(data)) {
            this.rod = (class_1799)this.method_5841().method_12789(DATA_ROD_ITEM);
        }
        if (DATA_CATCH_TYPE.equals(data) && this.method_37908().method_8608()) {
            this.catchType = CatchType.values()[(Integer)this.method_5841().method_12789(DATA_CATCH_TYPE)];
        }
        if (DATA_MINIGAME_ACTIVE.equals(data)) {
            this.minigameActive = (Boolean)this.method_5841().method_12789(DATA_MINIGAME_ACTIVE);
            if (!this.method_37908().method_8608() && !this.minigameActive) {
                this.restartFishingSequence();
            }
        }
        super.method_5674(data);
    }

    public boolean method_5640(double dst) {
        return dst < 4096.0;
    }

    public void method_5773() {
        class_1657 player;
        if (this.getRodItem() == null) {
            this.method_31472();
        }
        this.syncedRandom.method_43052(this.method_5667().getLeastSignificantBits() ^ this.method_37908().method_8510());
        super.method_5773();
        if (BaitUtils.getPrimaryBait(this.rod).method_31574(TideItems.LUCKY_BAIT) && this.currentState == FishHookState.BOBBING) {
            ++this.particleTimer;
            if (this.particleTimer >= 5) {
                this.method_37908().method_8406((class_2394)class_2398.field_29642, this.method_23322(0.8), this.method_23323((2.0 * this.field_5974.method_43058() - 1.0) * 0.4) + 0.2, this.method_23325(0.8), 0.0, 0.0, 0.0);
                this.particleTimer = 0;
            }
        }
        if ((player = this.getPlayerOwner()) == null) {
            this.method_31472();
        } else if (this.method_37908().field_9236 || this.shouldKeepFishing(player)) {
            boolean inMedium;
            if (this.method_24828()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.method_31472();
                    return;
                }
            } else {
                this.life = 0;
            }
            float fluidHeight = 0.0f;
            class_2338 pos = this.method_24515();
            this.fluidState = this.method_37908().method_8316(pos);
            this.medium = this.getCurrentMedium();
            if (this.medium != null) {
                fluidHeight = this.medium.getHeight(this);
            }
            boolean bl = inMedium = fluidHeight > 0.0f && this.medium != null;
            if (this.currentState == FishHookState.FLYING) {
                if (this.hookedIn != null) {
                    this.method_18799(class_243.field_1353);
                    this.currentState = FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (inMedium) {
                    this.method_18799(this.method_18798().method_18805(0.3, 0.2, 0.3));
                    this.currentState = FishHookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == FishHookState.HOOKED_IN_ENTITY) {
                    if (this.hookedIn != null) {
                        if (!this.hookedIn.method_31481() && this.hookedIn.method_37908().method_27983() == this.method_37908().method_27983()) {
                            this.method_5814(this.hookedIn.method_23317(), this.hookedIn.method_23323(0.8), this.hookedIn.method_23321());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == FishHookState.BOBBING) {
                    class_243 delta = this.method_18798();
                    double toSurface = this.method_23318() + delta.field_1351 - (double)pos.method_10264() - (double)fluidHeight;
                    if (Math.abs(toSurface) < 0.01) {
                        toSurface += Math.signum(toSurface) * 0.1;
                    }
                    this.method_18800(delta.field_1352 * 0.9, delta.field_1351 - toSurface * (double)this.field_5974.method_43057() * 0.2, delta.field_1350 * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 20 && this.calculateOpenWater(pos);
                    }
                    if (inMedium) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.method_18799(this.method_18798().method_1031(0.0, -0.1 * (double)this.syncedRandom.method_43057() * (double)this.syncedRandom.method_43057(), 0.0));
                        }
                        if (!this.method_37908().field_9236) {
                            this.catchingFish(pos);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(20, this.outOfWaterTime + 1);
                    }
                }
            }
            if (this.getCurrentMedium() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            if (this.currentState == FishHookState.FLYING && (this.method_24828() || this.field_5976)) {
                this.method_18799(class_243.field_1353);
            }
            double scalar = 0.92;
            this.method_18799(this.method_18798().method_1021(scalar));
            this.method_23311();
        }
    }

    @Nullable
    public FishingMedium getCurrentMedium() {
        return FishingMedium.MEDIUMS.stream().filter(medium -> medium.canFishIn(this)).findFirst().orElse(null);
    }

    private boolean shouldKeepFishing(class_1657 player) {
        boolean flag = player.method_6047().equals(this.rod);
        boolean flag1 = player.method_6079().equals(this.rod);
        if (!player.method_31481() && player.method_5805() && (flag || flag1) && !(this.method_5858((class_1297)player) > 1224.0)) {
            return true;
        }
        this.method_31472();
        return false;
    }

    private void checkCollision() {
        class_239 result = class_1675.method_49997((class_1297)this, this::method_26958);
        this.method_7488(result);
    }

    protected boolean method_26958(@NotNull class_1297 entity) {
        return super.method_26958(entity) || entity.method_5805() && entity instanceof class_1542;
    }

    protected void method_7454(@NotNull class_3966 result) {
        super.method_7454(result);
        if (!this.method_37908().field_9236) {
            if (result.method_17782() == this.method_24921()) {
                this.method_31472();
            }
            this.setHookedEntity(result.method_17782());
        }
    }

    protected void method_24920(@NotNull class_3965 result) {
        super.method_24920(result);
        this.method_18799(this.method_18798().method_1029().method_1021(result.method_24801((class_1297)this)));
    }

    private void setHookedEntity(class_1297 p_150158_) {
        this.hookedIn = p_150158_;
        this.method_5841().method_12778(DATA_HOOKED_ENTITY, (Object)(p_150158_ == null ? 0 : p_150158_.method_5628() + 1));
    }

    private void catchingFish(class_2338 pos) {
        List<class_1799> rewards;
        if (this.medium == null) {
            return;
        }
        if (Tide.PLATFORM.isModLoaded("stardew_fishing") && !(rewards = CompatHelper.stardewFishingGetRewards((HookAccessor)this.getPlayerOwner().field_7513)).isEmpty()) {
            return;
        }
        int i = 1;
        class_2338 abovePos = pos.method_10084();
        if (this.isWaterFishing() && (double)this.field_5974.method_43057() < 0.25 && this.method_37908().method_8520(abovePos)) {
            ++i;
        }
        if (this.isWaterFishing() && (double)this.field_5974.method_43057() < 0.5 && !this.method_37908().method_8311(abovePos)) {
            ++i;
        }
        if (this.nibble > 0) {
            if (!this.minigameActive) {
                --this.nibble;
            }
            if (this.nibble <= 0) {
                this.restartFishingSequence();
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)this.field_5974.method_43385(0.0, 9.188);
                float angleRad = this.fishAngle * ((float)Math.PI / 180);
                float sin = class_3532.method_15374((float)angleRad);
                float cos = class_3532.method_15362((float)angleRad);
                double fishX = this.method_23317() + (double)(sin * (float)this.timeUntilHooked * 0.1f);
                double fishY = (float)class_3532.method_15357((double)this.method_23318()) + 1.0f;
                double fishZ = this.method_23321() + (double)(cos * (float)this.timeUntilHooked * 0.1f);
                this.medium.drawFishTrail(this, angleRad, sin, cos, fishX, fishY, fishZ);
            } else {
                if (this.rod.method_31574(TideItems.CRYSTAL_FISHING_ROD)) {
                    this.method_37908().method_8396(null, this.getPlayerOwner().method_24515(), class_3417.field_43154, class_3419.field_15250, 1.5f, 1.0f - (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f);
                }
                this.medium.onFishBite(this);
                this.nibble = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)40);
                this.method_5841().method_12778(DATA_BITING, (Object)true);
                if (this.getPlayerOwner() != null) {
                    this.selectCatch(this.rod);
                } else {
                    this.catchType = CatchType.NOTHING;
                    this.method_5841().method_12778(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
                }
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.field_5974.method_43057() < f5) {
                float angleRad = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float distance = class_3532.method_15344((class_5819)this.field_5974, (float)25.0f, (float)60.0f);
                double x = this.method_23317() + (double)(class_3532.method_15374((float)angleRad) * distance) * 0.1;
                double y = (float)class_3532.method_15357((double)this.method_23318()) + 1.0f;
                double z = this.method_23321() + (double)(class_3532.method_15362((float)angleRad) * distance) * 0.1;
                this.medium.drawAmbientSplash(this, angleRad, distance, x, y, z);
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = (int)((double)class_3532.method_15395((class_5819)this.field_5974, (int)200, (int)600) * this.medium.biteTimeMultiplier());
            this.timeUntilLured -= (int)(1200.0 / (1.0 + Math.exp(-0.3 * (double)this.lureSpeed)) - 600.0);
            double globalBiteTimeMultiplier = Tide.PLATFORM.isModLoaded("stardew_fishing") ? CompatHelper.stardewFishingBiteTimeMultiplier() : 1.0;
            this.timeUntilLured = Math.max((int)((double)this.timeUntilLured * globalBiteTimeMultiplier), 10);
        }
    }

    private boolean isWaterFishing() {
        return this.medium == FishingMedium.WATER;
    }

    public void restartFishingSequence() {
        this.catchType = CatchType.NOTHING;
        this.method_5841().method_12778(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
        this.timeUntilLured = 0;
        this.timeUntilHooked = 0;
        this.method_5841().method_12778(DATA_BITING, (Object)false);
    }

    private boolean calculateOpenWater(class_2338 pos) {
        OpenFluidType openWaterType = OpenFluidType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenFluidType openWaterType1 = this.getOpenWaterTypeForArea(pos.method_10069(-2, i, -2), pos.method_10069(2, i, 2));
            switch (openWaterType1.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if (openWaterType != OpenFluidType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != OpenFluidType.ABOVE_WATER) break;
                    return false;
                }
            }
            openWaterType = openWaterType1;
        }
        return true;
    }

    private OpenFluidType getOpenWaterTypeForArea(class_2338 pos1, class_2338 pos2) {
        return class_2338.method_20437((class_2338)pos1, (class_2338)pos2).map(this::getOpenWaterTypeForBlock).reduce((type1, type2) -> type1 == type2 ? type1 : OpenFluidType.INVALID).orElse(OpenFluidType.INVALID);
    }

    private OpenFluidType getOpenWaterTypeForBlock(class_2338 pos) {
        class_2680 blockState = this.method_37908().method_8320(pos);
        if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10588)) {
            class_3610 fluidState = blockState.method_26227();
            return FishingMedium.WATER.canFishIn(this) && fluidState.method_15771() && blockState.method_26220((class_1922)this.method_37908(), pos).method_1110() ? OpenFluidType.INSIDE_WATER : OpenFluidType.INVALID;
        }
        return OpenFluidType.ABOVE_WATER;
    }

    public void method_5652(@NotNull class_2487 tag) {
    }

    public void method_5749(@NotNull class_2487 tag) {
    }

    public void retrieve() {
        this.retrieve(false);
    }

    public void retrieve(boolean perfectCatch) {
        if (this.getRodItem() == null) {
            this.method_31472();
        }
        this.wasPerfectCatch = perfectCatch;
        this.getRodItem().retrieveHook(this.rod, this.getPlayerOwner(), this.method_37908());
    }

    public int retrieve(class_1799 rod, class_3218 level, class_1657 player) {
        if (player == null || player.field_7513 == null || !(player instanceof class_3222)) {
            return 0;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (this.method_37908().field_9236 || !this.shouldKeepFishing(player)) {
            return 0;
        }
        int i = 0;
        if (this.getHookedIn() != null) {
            this.pullEntity(this.getHookedIn());
            class_174.field_1203.method_8939(serverPlayer, rod, player.field_7513, Collections.emptyList());
            this.method_37908().method_8421((class_1297)this, (byte)31);
            i = this.getHookedIn() instanceof class_1542 ? 3 : 5;
        } else if (this.nibble > 0) {
            if (!this.hasHookedItem()) {
                this.catchType = CatchType.NOTHING;
            }
            switch (this.catchType.ordinal()) {
                case 0: 
                case 2: {
                    if (this.medium == FishingMedium.LAVA) {
                        TideCriteriaTriggers.FISHED_IN_LAVA.trigger(serverPlayer);
                    }
                    if (this.medium == FishingMedium.VOID) {
                        TideCriteriaTriggers.FISHED_IN_VOID.trigger(serverPlayer);
                    }
                    class_174.field_1203.method_8939(serverPlayer, rod, player.field_7513, this.hookedItems);
                    List<class_1799> hookedItemsCopy = this.hookedItems.stream().map(class_1799::method_7972).toList();
                    for (class_1799 stack : this.hookedItems) {
                        class_1297 converted;
                        if (stack.method_7960()) continue;
                        class_1542 entity = this.medium == FishingMedium.LAVA ? new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack){

                            public boolean method_5862() {
                                return false;
                            }

                            public void method_5730() {
                            }
                        } : new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
                        double dx = player.method_23317() - this.method_23317();
                        double dy = player.method_23318() - this.method_23318();
                        double dz = player.method_23321() - this.method_23321();
                        entity.method_18800(dx * 0.1, dy * 0.11 + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * 0.08, dz * 0.1);
                        if (CompatHelper.isHybridAquaticLoaded() && entity instanceof class_1542) {
                            class_1542 itemEntity = entity;
                            entity = CompatHelper.hybridAquaticPullEntity(itemEntity, player, this);
                        }
                        if (Tide.PLATFORM.isModLoaded("fishingreal") && entity instanceof class_1542 && (converted = CompatHelper.fishingRealConvertItemStack(stack, player, this.method_19538())) != null) {
                            entity = converted;
                            this.method_37908().method_8649(converted);
                        }
                        if (entity instanceof class_1542) {
                            this.method_37908().method_8649((class_1297)entity);
                            if (stack.method_31573(class_3489.field_15527)) {
                                player.method_7339(class_3468.field_15391, 1);
                            }
                        }
                        player.method_37908().method_8649((class_1297)new class_1303(player.method_37908(), player.method_23317(), player.method_23318() + 0.5, player.method_23321() + 0.5, this.field_5974.method_43048(4) + (this.wasPerfectCatch ? 4 : 1)));
                        if (this.rod.method_31574(TideItems.DIAMOND_FISHING_ROD)) {
                            player.method_37908().method_8649((class_1297)new class_1303(player.method_37908(), player.method_23317(), player.method_23318() + 0.5, player.method_23321() + 0.5, this.field_5974.method_43048(4) + 1));
                        }
                        if (this.catchType != CatchType.FISH) continue;
                        if (!player.method_7337() && BaitUtils.isHoldingBait(rod)) {
                            BaitContents.Mutable contents = new BaitContents.Mutable(TideItemData.BAIT_CONTENTS.get(rod));
                            contents.shrinkStack(BaitUtils.getPrimaryBait(rod));
                            TideItemData.BAIT_CONTENTS.set(rod, contents.toImmutable());
                        }
                        TideUtils.tryLogCatch(stack, serverPlayer);
                    }
                    break;
                }
                case 1: {
                    class_2680 lootCrate = this.crateData.blockProvider().method_23455(this.field_5974, this.method_24515());
                    class_8567.class_8568 lootParamsBuilder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)rod).method_51874(class_181.field_1224, (Object)lootCrate).method_51874(class_181.field_1226, (Object)this);
                    class_8567 params = lootParamsBuilder.method_51871((float)this.luck + player.method_7292()).method_51875(class_173.field_1176);
                    level.method_8501(this.method_24515(), lootCrate);
                    double dx = player.method_23317() - (double)this.method_24515().method_10263();
                    double dy = player.method_23318() - (double)this.method_24515().method_10264();
                    double dz = player.method_23321() - (double)this.method_24515().method_10260();
                    LootCrateEntity.create((class_1937)level, this.method_24515(), lootCrate, dx * 0.0666, dy * 0.0666 + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * 0.082 + 0.27, dz * 0.0666, params, this.crateData.lootTable().map(LootTableRef::of).orElse(null));
                    if (this.fluidState.method_15767(TideTags.Fluids.LAVA_FISHING) && this.fluidState.method_39360((class_3611)class_3612.field_15908)) {
                        level.method_8501(this.method_24515(), class_2246.field_10164.method_9564());
                    }
                    if (this.fluidState.method_15767(TideTags.Fluids.WATER_FISHING) && this.fluidState.method_39360((class_3611)class_3612.field_15910)) {
                        level.method_8501(this.method_24515(), class_2246.field_10382.method_9564());
                    }
                    TideCriteriaTriggers.PULLED_CRATE.trigger(serverPlayer);
                    break;
                }
            }
            i = 1;
        }
        if (this.method_24828()) {
            i = 2;
        }
        this.startRetrieving();
        if (this.getLine().method_31574(TideItems.REINFORCED_LINE) && (i -= new Random().nextFloat() > 0.7f ? 1 : 0) < 0) {
            i = 0;
        }
        return i;
    }

    public void selectCatch(class_1799 rod) {
        FishingEntry fishingEntry;
        class_1799 bonusGold;
        MinecraftServer server = this.method_37908().method_8503();
        if (server == null) {
            return;
        }
        FishingContext context = this.getContext();
        class_8567 params = context.createFishingLootParams();
        CatchResult result = Tide.FISHING_MANAGER.selectCatch(context);
        if (result.isEmpty()) {
            Tide.LOG.warn("Could not find a valid catch for this context: {}", (Object)context);
            class_52 table = TideUtils.getLootTable(class_39.field_266, server);
            ObjectArrayList items = table.method_51878(params);
            this.hookedItems = items.isEmpty() ? List.of() : items;
        } else {
            this.hookedItems = result.items();
        }
        if (rod.method_31574(TideItems.MIDAS_FISHING_ROD) && this.medium != FishingMedium.LAVA && (bonusGold = TideUtils.getBonusGoldItem(server, params)) != null) {
            this.hookedItems = ImmutableList.builder().addAll(this.hookedItems).add((Object)bonusGold).build();
        }
        CatchType catchType = result.isFish() || this.hookedItems.stream().anyMatch(TideUtils::isJournalFish) ? CatchType.FISH : (this.catchType = this.hookedItems.isEmpty() ? CatchType.NOTHING : CatchType.ITEM);
        if (result.entry().isPresent() && result.isCrate() && (fishingEntry = result.entry().get()) instanceof CrateData) {
            CrateData data;
            this.crateData = data = (CrateData)fishingEntry;
            this.catchType = CatchType.CRATE;
        }
        this.method_5841().method_12778(DATA_CATCH_TYPE, (Object)this.catchType.ordinal());
    }

    public void method_5711(byte event) {
        if (event == 31 && this.method_37908().field_9236 && this.hookedIn instanceof class_1657 && ((class_1657)this.hookedIn).method_7340()) {
            this.pullEntity(this.hookedIn);
        }
        super.method_5711(event);
    }

    protected void pullEntity(class_1297 entity) {
        class_1297 owner = this.method_24921();
        if (owner != null) {
            class_243 vec3 = new class_243(owner.method_23317() - this.method_23317(), owner.method_23318() - this.method_23318(), owner.method_23321() - this.method_23321()).method_1021(0.1);
            entity.method_18799(entity.method_18798().method_1019(vec3));
        }
    }

    protected void startRetrieving() {
        this.catchType = CatchType.NOTHING;
        this.method_31472();
    }

    public FishingContext getContext() {
        return new FishingContext((class_3218)this.method_37908(), this, this.method_37908().method_8409(), this.method_19538(), this.method_24515(), class_3532.method_15375((float)((float)this.getLuck() + this.getPlayerOwner().method_7292())), Optional.ofNullable(this.medium).orElse(FishingMedium.WATER).id().method_12832(), BaitUtils.getPrimaryBait(this.rod), this.getBiome(), TideUtils.findClosestNonWaterBiome(this.method_37908(), this.method_24515(), 12, 2).orElse(this.getBiome()), (class_5321<class_1937>)this.method_37908().method_27983(), this.sampleTemperature(), this.method_37908().method_30273(), SeasonsCompat.getSeason(this.method_37908()));
    }

    public float sampleTemperature() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            Tide.LOG.error("Tried to sample temperature on the client");
            return 0.0f;
        }
        class_3218 level = (class_3218)class_19372;
        return TideUtils.getTemperatureAt(this.method_24515(), level);
    }

    @NotNull
    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5650(@NotNull class_1297.class_5529 reason) {
        this.updateOwnerInfo(null);
        super.method_5650(reason);
    }

    public void method_36209() {
        this.updateOwnerInfo(null);
    }

    public void method_7432(class_1297 entity) {
        super.method_7432(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(TideFishingHook hook) {
        class_1657 player = this.getPlayerOwner();
        if (player != null) {
            if (hook == null && player.field_7513 != null) {
                ((HookAccessor)player.field_7513).clearHook(player);
            }
            if (player.field_7513 == null && hook != null) {
                player.field_7513 = new HookAccessor(hook, this.method_37908());
            }
        }
    }

    public class_1657 getPlayerOwner() {
        class_1297 entity = this.method_24921();
        return entity instanceof class_1657 ? (class_1657)entity : null;
    }

    public class_1297 getHookedIn() {
        return this.hookedIn;
    }

    public void method_31471(@NotNull class_2604 packet) {
        super.method_31471(packet);
        if (this.getPlayerOwner() == null) {
            int i = packet.method_11166();
            Tide.LOG.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.method_37908().method_8469(i), (Object)i);
            this.method_31472();
        }
    }

    public boolean method_5753() {
        if (this.canFishInLava()) {
            return true;
        }
        return super.method_5753();
    }

    public boolean method_5809() {
        if (this.canFishInLava()) {
            return false;
        }
        return super.method_5809();
    }

    public boolean canFishInLava() {
        if (this.getRodItem() == null) {
            return false;
        }
        return this.getRodItem().isLavaproof(this.rod);
    }

    public boolean canFishInVoid() {
        if (this.getRodItem() == null) {
            return false;
        }
        return this.getRodItem().isVoidproof(this.rod);
    }

    public class_1799 rod() {
        return this.rod;
    }

    public TideFishingRodItem getRodItem() {
        class_1792 class_17922 = this.rod.method_7909();
        if (class_17922 instanceof TideFishingRodItem) {
            TideFishingRodItem rodItem = (TideFishingRodItem)class_17922;
            return rodItem;
        }
        return null;
    }

    public class_1799 getBobber() {
        return CustomRodManager.getBobber(this.rod);
    }

    public class_1799 getHook() {
        return CustomRodManager.getHook(this.rod);
    }

    public class_1799 getLine() {
        return CustomRodManager.getLine(this.rod);
    }

    public void clearHookItem() {
        class_1799 mainHandItem = this.getPlayerOwner().method_6047();
        class_1799 offhandItem = this.getPlayerOwner().method_6079();
        if (mainHandItem.method_7909() instanceof TideFishingRodItem) {
            CustomRodManager.setHook(mainHandItem, null);
            this.getPlayerOwner().method_6122(class_1268.field_5808, mainHandItem);
        } else if (offhandItem.method_7909() instanceof TideFishingRodItem) {
            CustomRodManager.setHook(offhandItem, null);
            this.getPlayerOwner().method_6122(class_1268.field_5810, offhandItem);
        }
    }

    public boolean hasHookedItem() {
        return this.hookedItems != null && !this.hookedItems.isEmpty();
    }

    public List<class_1799> getHookedItems() {
        return this.hookedItems;
    }

    public void setMinigameActive(boolean state) {
        this.minigameActive = state;
        if (!this.minigameActive) {
            this.nibble = 0;
        }
        this.field_6011.method_12778(DATA_MINIGAME_ACTIVE, (Object)state);
    }

    public CatchType getCatchType() {
        return CatchType.values()[(Integer)this.method_5841().method_12789(DATA_CATCH_TYPE)];
    }

    @NotNull
    public class_5819 getRandom() {
        return this.method_37908().method_8409();
    }

    static enum FishHookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    public static enum CatchType {
        FISH,
        CRATE,
        ITEM,
        NOTHING;

    }

    static enum OpenFluidType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

