/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc.fishing;

import com.li64.tide.Tide;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.TideFishingBobberLayer;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHookModel;
import com.li64.tide.registries.items.FishingHookItem;
import com.li64.tide.registries.items.FishingLineItem;
import java.awt.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class TideFishingHookRenderer
extends class_897<TideFishingHook>
implements class_3883<TideFishingHook, TideFishingHookModel<TideFishingHook>> {
    private final TideFishingHookModel<TideFishingHook> model;
    private final TideFishingBobberLayer bobberLayer;
    private static final class_2960 HOOK_TEX_LOCATION = Tide.resource("textures/entity/fishing_hook/fishing_hook.png");

    public TideFishingHookRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new TideFishingHookModel(context.method_32167(TideFishingHookModel.MODEL_LOCATION));
        this.bobberLayer = new TideFishingBobberLayer(this, context.method_32170(), context.method_32168());
        this.field_4673 = 0.1f;
    }

    public void render(TideFishingHook hookEntity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int packedLight) {
        class_1657 player = hookEntity.getPlayerOwner();
        if (player == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22903();
        poseStack.method_46416(0.03125f, 0.0f, 0.03125f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - hookEntity.getInitialYaw()));
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(hookEntity, partialTick, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23578((class_2960)this.getTextureLocation(hookEntity)));
        this.model.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        this.bobberLayer.render(poseStack, buffer, packedLight, hookEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        poseStack.method_22909();
        this.renderConnectingString(hookEntity, partialTick, poseStack, buffer, player);
        poseStack.method_22909();
        super.method_3936((class_1297)hookEntity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private void renderConnectingString(TideFishingHook hookEntity, float partialTick, class_4587 poseStack, class_4597 buffer, class_1657 player) {
        float f = player.method_6055(partialTick);
        float f1 = class_3532.method_15374((float)(class_3532.method_15355((float)f) * (float)Math.PI));
        class_243 vec3 = this.getPlayerHandPos(player, f1, partialTick);
        class_243 vec31 = hookEntity.method_30950(partialTick).method_1031(0.0, 0.25, 0.0);
        float f2 = (float)(vec3.field_1352 - vec31.field_1352);
        float f3 = (float)(vec3.field_1351 - vec31.field_1351);
        float f4 = (float)(vec3.field_1350 - vec31.field_1350);
        class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_34572());
        class_4587.class_4665 pose = poseStack.method_23760();
        for (int k = 0; k <= 16; ++k) {
            TideFishingHookRenderer.stringVertex(f2, f3, f4, vertexConsumer, pose, TideFishingHookRenderer.fraction(k), TideFishingHookRenderer.fraction(k + 1), player, FishingLineItem.getColor(hookEntity.getLine()), partialTick);
        }
        if (Tide.PLATFORM.isModLoaded("iris") || Tide.PLATFORM.isModLoaded("oculus")) {
            vertexConsumer.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_22914(0.0f, 0.0f, 0.0f);
        }
    }

    private class_243 getPlayerHandPos(class_1657 player, float anim, float partialTick) {
        class_241 stringOffset;
        int i = player.method_6068() == class_1306.field_6183 ? 1 : -1;
        class_1799 stack = player.method_6047();
        if (!(stack.method_7909() instanceof class_1787)) {
            i = -i;
        }
        class_241 class_2412 = stack.method_7909() == TideItems.STONE_FISHING_ROD ? new class_241(0.05f, -0.1f) : (stringOffset = stack.method_7909() == TideItems.IRON_FISHING_ROD ? new class_241(0.05f, -0.02f) : new class_241(0.0f, 0.0f));
        if (!Tide.PLATFORM.isModLoaded("firstperson") && this.field_4676.field_4692.method_31044().method_31034() && player == class_310.method_1551().field_1724) {
            double fovOption = ((Integer)this.field_4676.field_4692.method_41808().method_41753()).doubleValue();
            double d4 = 960.0 / fovOption;
            double fovScalar = (class_310.method_1551().field_1773.method_3196(this.field_4676.field_4686, partialTick, true) / fovOption - 1.0) * 2.5 + 1.0;
            class_243 vec3 = this.field_4676.field_4686.method_36425().method_36427((float)i * (0.525f + stringOffset.field_1343) * (float)fovScalar, (-0.1f + stringOffset.field_1342) * (float)fovScalar).method_1021(d4).method_1024(anim * 0.5f).method_1037(-anim * 0.7f);
            return player.method_5836(partialTick).method_1019(vec3);
        }
        float f = class_3532.method_16439((float)partialTick, (float)player.field_6220, (float)player.field_6283) * ((float)Math.PI / 180);
        double d0 = class_3532.method_15374((float)f);
        double d1 = class_3532.method_15362((float)f);
        float f1 = player.method_17825();
        double d2 = (double)i * 0.35 * (double)f1;
        double d3 = 0.8 * (double)f1;
        float f2 = player.method_18276() ? -0.1875f : 0.0f;
        return player.method_5836(partialTick).method_1031(-d1 * d2 - d0 * d3, (double)f2 - 0.45 * (double)f1, -d0 * d2 + d1 * d3);
    }

    private static float fraction(int pNumerator) {
        return (float)pNumerator / 16.0f;
    }

    private static void stringVertex(float x, float y, float z, class_4588 vertexConsumer, class_4587.class_4665 pose, float frac1, float frac2, class_1657 player, String colorHex, float partialTick) {
        float f = x * frac1;
        float f1 = y * (frac1 * frac1 + frac1) * 0.5f + 0.25f;
        float f2 = z * frac1;
        float f3 = x * frac2 - f;
        float f4 = y * (frac2 * frac2 + frac2) * 0.5f + 0.25f - f1;
        float f5 = z * frac2 - f2;
        float f6 = class_3532.method_15355((float)(f3 * f3 + f4 * f4 + f5 * f5));
        f3 /= f6;
        f4 /= f6;
        f5 /= f6;
        Color color = Color.decode(colorHex);
        class_2338 samplePos = player.method_24515().method_10084();
        float skyDarken = (1.0f - ((class_638)player.method_37908()).method_23783(partialTick)) * 15.0f;
        float blockBrightness = player.method_37908().method_8314(class_1944.field_9282, samplePos);
        float skyBrightness = (float)player.method_37908().method_8314(class_1944.field_9284, samplePos) - skyDarken + 1.0f;
        float colorBrightness = Tide.CONFIG.general.defaultLineColor ? 0.0f : class_3532.method_15363((float)(Math.max(blockBrightness, skyBrightness) / 15.0f), (float)player.method_37908().method_8597().comp_656(), (float)1.0f);
        int r = (int)((float)color.getRed() * colorBrightness);
        int g = (int)((float)color.getGreen() * colorBrightness);
        int b = (int)((float)color.getBlue() * colorBrightness);
        vertexConsumer.method_22918(pose.method_23761(), f, f1, f2).method_39415(class_5253.class_5254.method_27764((int)255, (int)r, (int)g, (int)b)).method_23763(pose.method_23762(), f3, f4, f5).method_1344();
    }

    @NotNull
    public TideFishingHookModel<TideFishingHook> getModel() {
        return this.model;
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull TideFishingHook hookEntity) {
        if (!this.allowModifiers()) {
            return HOOK_TEX_LOCATION;
        }
        return FishingHookItem.getTexture(hookEntity.getHook());
    }

    protected boolean allowModifiers() {
        return true;
    }
}

