/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.models;

import com.li64.tide.Tide;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.class_1308;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_630;

public abstract class FishModel
extends class_583<class_1308> {
    private final ArrayList<SwimAnimConfig> swimConfigs = new ArrayList();
    private final class_630 root;

    protected FishModel(class_5617.class_5618 context, class_5601 modelLocation) {
        this.root = context.method_32167(modelLocation);
    }

    protected class_630 root() {
        return this.root;
    }

    protected void addSwimAnimation(String path, float speed, float magnitude) {
        this.addSwimAnimation(path, speed, magnitude, 0.0f);
    }

    protected void addSwimAnimation(String path, float speed, float magnitude, SwimAxis axis) {
        this.addSwimAnimation(path, speed, magnitude, 0.0f, 0.0f, axis);
    }

    protected void addSwimAnimation(String path, float speed, float magnitude, float offset) {
        this.addSwimAnimation(path, speed, magnitude, offset, 0.0f, SwimAxis.Y);
    }

    protected void addSwimAnimation(String path, float speed, float magnitude, float offset, SwimAxis axis) {
        this.addSwimAnimation(path, speed, magnitude, offset, 0.0f, axis);
    }

    protected void addSwimAnimation(String path, float speed, float magnitude, float offset, float origin, SwimAxis axis) {
        String[] parts = path.split("/");
        class_630 current = this.root();
        if (!path.isEmpty()) {
            for (String part : parts) {
                current = current.method_32086(part);
            }
        }
        this.addSwimAnimation(current, speed, magnitude, offset, origin, axis);
    }

    protected void addSwimAnimation(class_630 part, float speed, float magnitude, float offset, float origin, SwimAxis axis) {
        this.swimConfigs.add(new SwimAnimConfig(part, speed, magnitude, offset, origin, axis));
    }

    protected static class_5601 createModelLocation(String name) {
        return new class_5601(Tide.resource(name), "main");
    }

    public void setupAnim(class_1308 fish, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float multiplier = fish.method_5816() || fish.method_5771() ? 1.0f : 1.5f;
        this.swimConfigs.forEach(config -> config.animate(ageInTicks, multiplier, ageInTicks == 0.0f));
    }

    public double xTiltScale() {
        return 1.0;
    }

    public float swimAnimSpeed() {
        return 0.6f;
    }

    public float swimAnimScale() {
        return 1.0f;
    }

    public float shadowRadius() {
        return 0.3f;
    }

    public int tint() {
        return -1;
    }

    public boolean renderTranslucent() {
        return false;
    }

    public int brightnessOverride() {
        return 0;
    }

    public boolean flipInAir() {
        return true;
    }

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        if (this.tint() != -1) {
            this.root().method_22699(poseStack, buffer, packedLight, packedOverlay, r * ((float)class_5253.class_5254.method_27765((int)this.tint()) / 255.0f), g * ((float)class_5253.class_5254.method_27766((int)this.tint()) / 255.0f), b * ((float)class_5253.class_5254.method_27767((int)this.tint()) / 255.0f), a * ((float)class_5253.class_5254.method_27762((int)this.tint()) / 255.0f));
        } else {
            this.root().method_22699(poseStack, buffer, packedLight, packedOverlay, r, g, b, a);
        }
    }

    protected static enum SwimAxis {
        X((part, rot) -> {
            part.field_3654 = rot.floatValue();
        }),
        Y((part, rot) -> {
            part.field_3675 = rot.floatValue();
        }),
        Z((part, rot) -> {
            part.field_3674 = rot.floatValue();
        });

        private final BiConsumer<class_630, Float> rotator;

        private SwimAxis(BiConsumer<class_630, Float> rotator) {
            this.rotator = rotator;
        }

        public void apply(class_630 part, float rot) {
            this.rotator.accept(part, Float.valueOf(rot));
        }
    }

    private record SwimAnimConfig(class_630 modelPart, float speed, float magnitude, float offset, float origin, SwimAxis axis) {
        public void animate(float clock, float multiplier, boolean isDisplay) {
            this.axis.apply(this.modelPart, -multiplier * this.magnitude * class_3532.method_15374((float)(this.speed * clock + (isDisplay ? 0.0f : this.offset))) + this.origin);
        }
    }
}

