/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.renderers;

import com.li64.tide.Tide;
import com.li64.tide.registries.entities.models.FishModel;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishRenderer<M extends FishModel>
extends class_927<class_1308, FishModel> {
    private final class_2960 texLocation;
    private final double xTiltScale;
    private final float swimAnimSpeed;
    private final float swimAnimScale;
    private final boolean renderTranslucent;

    public FishRenderer(String key, M model, class_5617.class_5618 context) {
        super(context, model, ((FishModel)((Object)model)).shadowRadius());
        this.texLocation = Tide.resource("textures/entity/fish/" + key + ".png");
        this.xTiltScale = ((FishModel)((Object)model)).xTiltScale();
        this.swimAnimSpeed = ((FishModel)((Object)model)).swimAnimSpeed();
        this.swimAnimScale = ((FishModel)((Object)model)).swimAnimScale();
        this.renderTranslucent = ((FishModel)((Object)model)).renderTranslucent();
    }

    @NotNull
    public class_2960 getTextureLocation() {
        return this.texLocation;
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull class_1308 entity) {
        return this.getTextureLocation();
    }

    protected void setupRotations(class_1308 fish, class_4587 poseStack, float bob, float yBodyRot, float partialTick) {
        super.method_4058((class_1309)fish, poseStack, bob, yBodyRot, partialTick);
        float f = this.swimAnimScale * 4.3f * class_3532.method_15374((float)(this.swimAnimSpeed * ((float)fish.field_6012 + partialTick)));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(f));
        if (!fish.method_5816() && !fish.method_5771() && this.flipInAir()) {
            poseStack.method_46416(0.1f, 0.1f, -0.1f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
        } else {
            float tilt = class_3532.method_15363((float)((float)(fish.method_18798().method_10214() * 1.5 * this.xTiltScale)), (float)-1.5707964f, (float)1.5707964f);
            if (Tide.PLATFORM.isModLoaded("alexscaves")) {
                poseStack.method_22907(class_7833.field_40714.rotation(tilt));
            } else {
                fish.method_36457(tilt);
                poseStack.method_22907(class_7833.field_40714.rotation(class_3532.method_16439((float)partialTick, (float)fish.field_6004, (float)fish.method_36455())));
            }
        }
    }

    private boolean flipInAir() {
        return ((FishModel)this.field_4737).flipInAir();
    }

    @Nullable
    protected class_1921 getRenderType(@NotNull class_1308 fish, boolean isVisible, boolean renderTranslucent, boolean appearsGlowing) {
        if (this.renderTranslucent) {
            return class_1921.method_23580((class_2960)this.getTextureLocation(fish));
        }
        return super.method_24302((class_1309)fish, isVisible, renderTranslucent, appearsGlowing);
    }

    protected int getBlockLightLevel(@NotNull class_1308 entity, @NotNull class_2338 pos) {
        return Math.max(super.method_24087((class_1297)entity, pos), ((FishModel)this.field_4737).brightnessOverride());
    }
}

