/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.util;

import com.google.common.collect.ImmutableList;
import com.li64.tide.data.TideData;
import com.li64.tide.data.item.TideItemData;
import com.li64.tide.data.rods.BaitContents;
import com.li64.tide.data.rods.BaitData;
import com.li64.tide.registries.TideItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class BaitUtils {
    public static boolean isHoldingBait(class_1799 rod) {
        return BaitUtils.isBait(BaitUtils.getPrimaryBait(rod));
    }

    public static class_1799 getPrimaryBait(class_1799 rod) {
        BaitContents contents = TideItemData.BAIT_CONTENTS.get(rod);
        if (contents == null || contents.items() == null) {
            return class_1802.field_8162.method_7854();
        }
        for (int i = 0; i < contents.size(); ++i) {
            class_1799 stack = contents.get(i);
            if (!BaitUtils.isBait(stack)) continue;
            return stack;
        }
        return class_1802.field_8162.method_7854();
    }

    public static boolean isBait(class_1799 stack) {
        return ((List)TideData.BAIT.get()).stream().anyMatch(baitData -> stack.method_31574(baitData.getItem()));
    }

    public static Optional<BaitData> getBaitData(class_1799 stack) {
        return ((List)TideData.BAIT.get()).stream().filter(baitData -> stack.method_31574(baitData.getItem())).findFirst();
    }

    public static int getBaitSpeed(class_1799 stack) {
        return BaitUtils.getBaitData(stack).map(BaitData::speedBonus).orElse(0);
    }

    public static int getBaitLuck(class_1799 stack) {
        return BaitUtils.getBaitData(stack).map(BaitData::luckBonus).orElse(0);
    }

    public static int getCrateChance(class_1799 stack) {
        return stack.method_31574(TideItems.MAGNETIC_BAIT) ? 25 : 0;
    }

    public static List<class_2561> getDescriptionLines(class_1799 bait) {
        ArrayList<class_5250> builder = new ArrayList<class_5250>();
        if (!BaitUtils.isBait(bait)) {
            return ImmutableList.copyOf(builder);
        }
        int speed = BaitUtils.getBaitSpeed(bait);
        int luck = BaitUtils.getBaitLuck(bait);
        int crateChance = BaitUtils.getCrateChance(bait);
        if (speed != 0) {
            builder.add(class_2561.method_43469((String)"text.tide.bait_tooltip.speed", (Object[])new Object[]{(speed < 0 ? "-" : "+") + speed}).method_27692(class_124.field_1078));
        }
        if (luck != 0) {
            builder.add(class_2561.method_43469((String)"text.tide.bait_tooltip.lucky", (Object[])new Object[]{(luck < 0 ? "-" : "+") + luck}).method_27692(class_124.field_1078));
        }
        if (crateChance != 0) {
            builder.add(class_2561.method_43469((String)"text.tide.bait_tooltip.crate", (Object[])new Object[]{(crateChance < 0 ? "-" : "+") + crateChance + "%"}).method_27692(class_124.field_1078));
        }
        if (!builder.isEmpty()) {
            builder.add(0, class_2561.method_43471((String)"text.tide.bait_tooltip.prefix").method_27692(class_124.field_1080));
        } else {
            builder.add(0, class_2561.method_43471((String)"text.tide.bait_tooltip.unknown_effects").method_27692(class_124.field_1080));
        }
        builder.add(0, class_2561.method_43473());
        return ImmutableList.copyOf(builder);
    }
}

