/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.util;

import com.li64.tide.Tide;
import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.item.TideItemData;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ShowToastMsg;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7836;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;

public class TideUtils {
    public static boolean isJournalFish(class_1799 fish) {
        return TideUtils.isJournalFish(fish.method_7909());
    }

    public static boolean isJournalFish(class_1792 fish) {
        return FishData.get(fish).map(FishData::showInJournal).orElse(false);
    }

    public static class_2561 removeRawTextInName(class_2561 initialName) {
        String toReplace = class_2561.method_43471((String)"journal.remove_from_names").getString();
        String filtered = class_2561.method_43471((String)initialName.getString()).getString().replace(toReplace, "");
        return class_2561.method_43470((String)(filtered.substring(0, 1).toUpperCase() + filtered.substring(1)));
    }

    public static void showFishToast(class_1799 stack, class_3222 player) {
        Tide.NETWORK.sendToPlayer(new ShowToastMsg((class_2561)class_2561.method_43471((String)"newfish.toast.title"), TideUtils.removeRawTextInName(stack.method_7964()), stack), player);
    }

    public static class_1792 itemFromLocation(class_2960 location) {
        return class_7923.field_41178.method_17966(location).orElse((class_1792)class_7923.field_41178.method_10223(class_7923.field_41178.method_10221((Object)class_1802.field_8162)));
    }

    public static Optional<FishData> getStrongest(List<class_1799> hookedItems) {
        float bestStrength = 0.0f;
        FishData best = null;
        for (class_1799 hookedItem : hookedItems) {
            float strength;
            Optional<FishData> data = FishData.get(hookedItem);
            if (data.isEmpty() || !((strength = data.get().strength()) >= bestStrength)) continue;
            bestStrength = strength;
            best = data.orElse(null);
        }
        return Optional.ofNullable(best);
    }

    public static class_1799 getBonusGoldItem(MinecraftServer server, class_8567 params) {
        class_52 table = TideLootTables.Fishing.BONUS_GOLD.getTable(server);
        if (table == class_52.field_948) {
            return null;
        }
        return (class_1799)table.method_51878(params).get(0);
    }

    public static boolean tryLogCatch(class_1799 stack, class_3222 player) {
        if (!TideUtils.isJournalFish(stack)) {
            return false;
        }
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        data.logCatch(stack, player, player.method_37908());
        data.syncTo(player);
        return true;
    }

    public static Optional<class_6880<class_1959>> findClosestNonWaterBiome(class_1937 level, class_2338 origin, int radius, int step) {
        int steps = Math.floorDiv(radius, step);
        int[] relativeYs = class_3532.method_42117((int)0, (int)(-radius), (int)radius, (int)step).toArray();
        for (class_2338.class_2339 mPos : class_2338.method_30512((class_2338)class_2338.field_10980, (int)steps, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
            int x = origin.method_10263() + mPos.method_10263() * step;
            int z = origin.method_10260() + mPos.method_10260() * step;
            int qx = class_5742.method_33100((int)x);
            int qz = class_5742.method_33100((int)z);
            for (int y : relativeYs) {
                int qy = class_5742.method_33100((int)(y + origin.method_10264()));
                class_6880 biome = level.method_16359(qx, qy, qz);
                if (biome.method_40220(TideTags.Biomes.WATER_BIOMES)) continue;
                return Optional.of(biome);
            }
        }
        return Optional.empty();
    }

    public static float getTemperatureAt(class_2338 pos, class_3218 level) {
        class_6544.class_6552 sampler = level.method_14178().method_41248().method_42371();
        int x = class_5742.method_33100((int)pos.method_10263());
        int y = class_5742.method_33100((int)pos.method_10264());
        int z = class_5742.method_33100((int)pos.method_10260());
        class_6544.class_6553 targetPoint = sampler.method_40444(x, y, z);
        return class_6544.method_38666((long)targetPoint.comp_112());
    }

    public static class_5250 getFormattedLength(class_1799 stack) {
        return TideUtils.getFormattedLength(TideItemData.FISH_LENGTH.getOrDefault(stack, 0.0));
    }

    public static class_5250 getFormattedLength(double length) {
        String formatted;
        if (length >= 100.0) {
            DecimalFormat metersFormat = new DecimalFormat("#.##");
            formatted = metersFormat.format(length / 100.0) + " m";
        } else {
            DecimalFormat cmFormat = new DecimalFormat("#.#");
            formatted = cmFormat.format(length) + " cm";
        }
        return class_2561.method_43470((String)formatted);
    }

    public static boolean isFishAlive(class_1799 stack, long currentTime) {
        long timestamp = TideItemData.CATCH_TIMESTAMP.getOrDefault(stack, -1L);
        return timestamp >= 0L && currentTime - timestamp < Tide.CONFIG.items.fishItemLifespan * 20L;
    }

    public static float mcTempToRealTemp(float mcTemp) {
        float celsius = (float)(11.0 * Math.pow((double)mcTemp - 0.23, 3.0) + (double)(30.0f * mcTemp) + 15.0);
        if (Tide.CONFIG.journal.useFahrenheit) {
            return celsius * 1.8f + 32.0f;
        }
        return celsius;
    }

    public static String ticksToRealTime(long time, boolean useAmPm) {
        double timeInHours = (double)time / 1000.0 + 6.0;
        if (timeInHours >= 24.0) {
            timeInHours -= 24.0;
        }
        int hour = (int)Math.floor(timeInHours);
        int minute = (int)Math.floor((timeInHours - (double)hour) * 60.0);
        if (useAmPm) {
            String amPm = hour < 12 ? "AM" : "PM";
            int hour12 = hour % 12;
            if (hour12 == 0) {
                hour12 = 12;
            }
            return String.format("%d:%02d %s", hour12, minute, amPm);
        }
        return String.format("%02d:%02d", hour, minute);
    }

    public static class_2960 sprite(String path) {
        return Tide.resource("textures/gui/sprites/" + path + ".png");
    }

    public static class_2960 holderId(class_6880<class_1792> holder) {
        return (class_2960)holder.method_40229().map(class_5321::method_29177, arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0));
    }

    public static long getTimeOfDay(class_3218 level) {
        return level.method_8532() % 24000L;
    }

    public static class_52 getLootTable(class_2960 id, MinecraftServer server) {
        return server.method_3857().getLootTable(id);
    }

    public static void blitNineSliced(class_332 graphics, class_2960 tex, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int textureX, int textureY, int textureWidth, int textureHeight) {
        TideUtils.blitNineSliced(graphics, tex, x, y, width, height, sliceWidth, sliceHeight, sliceWidth, sliceHeight, uWidth, vHeight, textureX, textureY, textureWidth, textureHeight);
    }

    public static void blitNineSliced(class_332 graphics, class_2960 tex, int x, int y, int width, int height, int left, int top, int right, int bottom, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        left = Math.min(left, width / 2);
        right = Math.min(right, width / 2);
        top = Math.min(top, height / 2);
        bottom = Math.min(bottom, height / 2);
        if (width == uWidth && height == vHeight) {
            graphics.method_25290(tex, x, y, (float)uOffset, (float)vOffset, width, height, textureWidth, textureHeight);
        } else if (height == vHeight) {
            graphics.method_25290(tex, x, y, (float)uOffset, (float)vOffset, left, height, textureWidth, textureHeight);
            TideUtils.blitRepeating(graphics, tex, x + left, y, width - right - left, height, uOffset + left, vOffset, uWidth - right - left, vHeight, textureWidth, textureHeight);
            graphics.method_25290(tex, x + width - right, y, (float)(uOffset + uWidth - right), (float)vOffset, right, height, textureWidth, textureHeight);
        } else if (width == uWidth) {
            graphics.method_25290(tex, x, y, (float)uOffset, (float)vOffset, width, top, textureWidth, textureHeight);
            TideUtils.blitRepeating(graphics, tex, x, y + top, width, height - bottom - top, uOffset, vOffset + top, uWidth, vHeight - bottom - top, textureWidth, textureHeight);
            graphics.method_25290(tex, x, y + height - bottom, (float)uOffset, (float)(vOffset + vHeight - bottom), width, bottom, textureWidth, textureHeight);
        } else {
            graphics.method_25290(tex, x, y, (float)uOffset, (float)vOffset, left, top, textureWidth, textureHeight);
            TideUtils.blitRepeating(graphics, tex, x + left, y, width - right - left, top, uOffset + left, vOffset, uWidth - right - left, top, textureWidth, textureHeight);
            graphics.method_25290(tex, x + width - right, y, (float)(uOffset + uWidth - right), (float)vOffset, right, top, textureWidth, textureHeight);
            graphics.method_25290(tex, x, y + height - bottom, (float)uOffset, (float)(vOffset + vHeight - bottom), left, bottom, textureWidth, textureHeight);
            TideUtils.blitRepeating(graphics, tex, x + left, y + height - bottom, width - right - left, bottom, uOffset + left, vOffset + vHeight - bottom, uWidth - right - left, bottom, textureWidth, textureHeight);
            graphics.method_25290(tex, x + width - right, y + height - bottom, (float)(uOffset + uWidth - right), (float)(vOffset + vHeight - bottom), right, bottom, textureWidth, textureHeight);
            TideUtils.blitRepeating(graphics, tex, x, y + top, left, height - bottom - top, uOffset, vOffset + top, left, vHeight - bottom - top, textureWidth, textureHeight);
            TideUtils.blitRepeating(graphics, tex, x + left, y + top, width - right - left, height - bottom - top, uOffset + left, vOffset + top, uWidth - right - left, vHeight - bottom - top, textureWidth, textureHeight);
            TideUtils.blitRepeating(graphics, tex, x + width - right, y + top, left, height - bottom - top, uOffset + uWidth - right, vOffset + top, right, vHeight - bottom - top, textureWidth, textureHeight);
        }
    }

    private static void blitRepeating(class_332 graphics, class_2960 atlasLocation, int x, int y, int width, int height, int uOffset, int vOffset, int uWidth, int uHeight, int textureWidth, int textureHeight) {
        int i = x;
        IntIterator intIterator = TideUtils.slices(width, uWidth);
        while (intIterator.hasNext()) {
            int j = intIterator.nextInt();
            int k = (uWidth - j) / 2;
            int l = y;
            IntIterator intIterator2 = TideUtils.slices(height, uHeight);
            while (intIterator2.hasNext()) {
                int m = intIterator2.nextInt();
                int n = (uHeight - m) / 2;
                graphics.method_25290(atlasLocation, i, l, (float)(uOffset + k), (float)(vOffset + n), j, m, textureWidth, textureHeight);
                l += m;
            }
            i += j;
        }
    }

    private static IntIterator slices(int target, int total) {
        int i = class_3532.method_38788((int)target, (int)total);
        return new class_7836(target, i);
    }
}

