/*
 * Decompiled with CFR 0.152.
 */
package net.fryc.unremovableeffects.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.InputStream;
import java.util.Collection;
import net.fryc.unremovableeffects.UnremovableEffects;
import net.fryc.unremovableeffects.json.ReplaceManager;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class FrycJsonHelper {
    public static class_1291 asStatusEffect(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            String string = element.getAsString();
            return (class_1291)class_7923.field_41174.method_17966(new class_2960(string)).orElseThrow(() -> new JsonSyntaxException("Expected " + name + " to be a status effect, was unknown string '" + string + "'"));
        }
        throw new JsonSyntaxException("Expected " + name + " to be a status effect, was " + class_3518.method_15266((JsonElement)element));
    }

    public static <T> void manageReloadingWithReplacing(class_3300 manager, String resourcesPath, String arrayElement, Collection<T> collection, JsonSupplier<T> jsonSupplier) {
        ReplaceManager replaceManager = new ReplaceManager();
        for (class_2960 id : manager.method_14488(resourcesPath, path -> path.method_12832().endsWith(".json")).keySet()) {
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    JsonObject jsonObject = JsonParser.parseString((String)new String(stream.readAllBytes())).getAsJsonObject();
                    FrycJsonHelper.manageReloadingWithReplacing(id.method_12832(), jsonObject, arrayElement, collection, jsonSupplier, replaceManager);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                UnremovableEffects.LOGGER.error("Error occurred while loading resource json" + id.toString(), (Throwable)e);
            }
        }
    }

    public static <T> void manageReloadingWithReplacing(String filePath, JsonObject jsonObject, String arrayElement, Collection<T> collection, JsonSupplier<T> jsonSupplier, ReplaceManager replaceManager) {
        boolean shouldGo;
        boolean replace = class_3518.method_15258((JsonObject)jsonObject, (String)"replace", (boolean)false);
        boolean bl = shouldGo = !replaceManager.isReplacePresent() || replace;
        if (replace) {
            int replacePriority = class_3518.method_15282((JsonObject)jsonObject, (String)"replace_priority", (int)0);
            if (replaceManager.isReplacePresent()) {
                if (replacePriority > replaceManager.getCurrentReplacePriority()) {
                    replaceManager.setCurrentReplacePriority(replacePriority);
                    collection.clear();
                } else {
                    if (replaceManager.getCurrentReplacePriority() == replacePriority) {
                        UnremovableEffects.LOGGER.warn("Found two Json files with the same replace priority! Consider changing priority in one of the files");
                        UnremovableEffects.LOGGER.warn("'" + filePath + "' was ignored - other file was loaded first");
                    }
                    shouldGo = false;
                }
            } else {
                collection.clear();
                replaceManager.setReplacePresent(true);
                replaceManager.setCurrentReplacePriority(replacePriority);
            }
        }
        if (shouldGo) {
            JsonArray array = class_3518.method_15261((JsonObject)jsonObject, (String)arrayElement);
            for (JsonElement jsonElement : array) {
                T effect = jsonSupplier.get(jsonElement, "array_element");
                collection.add(effect);
            }
        }
    }

    @FunctionalInterface
    public static interface JsonSupplier<T> {
        public T get(JsonElement var1, String var2);
    }
}

