/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.GenerateWaystoneNameEvent;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.worldgen.namegen.CustomNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.INameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.MixedNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.MrPorkNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.RomanNumber;
import net.blay09.mods.waystones.worldgen.namegen.SequencedNameGenerator;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class NameGenerator
extends class_18 {
    private static final String DATA_NAME = "waystones_NameGenerator";
    private static final String USED_NAMES = "UsedNames";
    private static final NameGenerator clientStorageCopy = new NameGenerator();
    private final Set<String> usedNames = Sets.newHashSet();

    private INameGenerator getNameGenerator(NameGenerationMode nameGenerationMode) {
        switch (nameGenerationMode) {
            case MIXED: {
                return new MixedNameGenerator(new MrPorkNameGenerator(), new CustomNameGenerator(false, this.usedNames));
            }
            case RANDOM_ONLY: {
                return new MrPorkNameGenerator();
            }
            case PRESET_ONLY: {
                return new CustomNameGenerator(true, this.usedNames);
            }
        }
        return new SequencedNameGenerator(new CustomNameGenerator(false, this.usedNames), new MrPorkNameGenerator());
    }

    public synchronized String getName(IWaystone waystone, class_5819 rand, NameGenerationMode nameGenerationMode) {
        INameGenerator nameGenerator = this.getNameGenerator(nameGenerationMode);
        String originalName = nameGenerator.randomName(rand);
        if (originalName == null) {
            originalName = Objects.requireNonNull(new MrPorkNameGenerator().randomName(rand));
        }
        String name = this.resolveDuplicate(originalName);
        GenerateWaystoneNameEvent event = new GenerateWaystoneNameEvent(waystone, name);
        Balm.getEvents().fireEvent((Object)event);
        name = event.getName();
        this.usedNames.add(name);
        this.method_80();
        return name;
    }

    private String resolveDuplicate(String name) {
        Object tryName = name;
        int i = 1;
        while (this.usedNames.contains(tryName)) {
            tryName = name + " " + RomanNumber.toRoman(i);
            ++i;
        }
        return tryName;
    }

    public static NameGenerator load(class_2487 compound) {
        NameGenerator nameGenerator = new NameGenerator();
        class_2499 tagList = compound.method_10554(USED_NAMES, 8);
        for (class_2520 tag : tagList) {
            nameGenerator.usedNames.add(tag.method_10714());
        }
        return nameGenerator;
    }

    public class_2487 method_75(class_2487 compound) {
        class_2499 tagList = new class_2499();
        for (String entry : this.usedNames) {
            tagList.add((Object)class_2519.method_23256((String)entry));
        }
        compound.method_10566(USED_NAMES, (class_2520)tagList);
        return compound;
    }

    public static NameGenerator get(@Nullable MinecraftServer server) {
        if (server != null) {
            class_3218 overworld = server.method_3847(class_1937.field_25179);
            return (NameGenerator)Objects.requireNonNull(overworld).method_17983().method_17924(NameGenerator::load, NameGenerator::new, DATA_NAME);
        }
        return clientStorageCopy;
    }
}

