/*
 * Decompiled with CFR 0.152.
 */
package net.birchfolks.wetlands.entity.custom;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import net.birchfolks.wetlands.item.WetlandsItems;
import net.birchfolks.wetlands.particles.WetlandsParticles;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WispEntity
extends class_1308
implements GeoEntity {
    private static final class_2940<Byte> WISP_FLAGS = class_2945.method_12791(WispEntity.class, (class_2941)class_2943.field_13319);
    private static final int ROOSTING_FLAG = 1;
    private static final class_4051 CLOSE_PLAYER_PREDICATE = class_4051.method_36626().method_18418(4.0);
    @Nullable
    private class_2338 hangingPosition;
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WispEntity(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5684(true);
        this.method_5875(true);
    }

    public void setVelocity(double x, double y, double z, float speed, float divergence) {
        class_243 vec3d = new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43385(0.0, 0.0172275 * (double)divergence), this.field_5974.method_43385(0.0, 0.0172275 * (double)divergence), this.field_5974.method_43385(0.0, 0.0172275 * (double)divergence)).method_1021((double)speed);
        this.method_18799(vec3d);
        double d = vec3d.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)d) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public void setVelocity(class_1297 shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float g = -class_3532.method_15374((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        this.setVelocity(f, g, h, speed, divergence);
        class_243 vec3d = shooter.method_18798();
        this.method_18799(this.method_18798().method_1031(vec3d.field_1352, shooter.method_24828() ? 0.0 : vec3d.field_1351, vec3d.field_1350));
    }

    public static boolean isSpawnDark(class_5425 world, class_2338 pos, class_5819 random) {
        if (world.method_8314(class_1944.field_9284, pos) > random.method_43048(32)) {
            return false;
        }
        class_2874 dimensionType = world.method_8597();
        int i = dimensionType.method_44223();
        if (i < 15 && world.method_8314(class_1944.field_9282, pos) > i) {
            return false;
        }
        int j = world.method_8410().method_8546() ? world.method_22346(pos, 10) : world.method_22339(pos);
        return j <= dimensionType.method_44222().method_35008(random);
    }

    public static boolean canMobSpawn(class_1299<? extends class_1308> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_238 box = new class_238(pos.method_10069(-10, -10, -10), pos.method_10069(10, 10, 10));
        List entities = world.method_8390(class_1309.class, box, class_1301.field_6156);
        for (class_1309 ent : entities) {
            if (!(ent instanceof WispEntity)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSpawnInDark(class_1299<? extends WispEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8410().method_23886();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8469)) {
            class_1799 itemStack2 = class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)WetlandsItems.BOTTLED_WISP.method_7854());
            player.method_6122(hand, itemStack2);
            this.method_5650(class_1297.class_5529.field_26998);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23718, 0.0).method_26868(class_5134.field_23721, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<WispEntity> wispEntityAnimationState) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(WISP_FLAGS, (Object)0);
    }

    protected float method_6107() {
        return 0.1f;
    }

    public float method_6017() {
        return super.method_6017() * 0.95f;
    }

    @Nullable
    public class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 source) {
        return null;
    }

    protected class_3414 method_6002() {
        return null;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608() && this.method_37908().method_8530()) {
            this.method_5650(class_1297.class_5529.field_26998);
        }
        this.method_37908().method_8406((class_2394)WetlandsParticles.WISP_PARTICLES, this.method_23317() + (double)this.field_5974.method_43057() * 0.25, this.method_23318() + (double)this.field_5974.method_43057() * 0.25, this.method_23321() + (double)this.field_5974.method_43057() * 0.25, 0.0, 0.0, 0.0);
    }

    protected void method_5958() {
        super.method_5958();
        for (class_1657 player : this.method_37908().method_18456()) {
            double dist = player.method_5739((class_1297)this);
            if (dist < 8.0) {
                if (this.field_6012 <= 25 || player.method_7337()) continue;
                class_243 vec = this.method_19538().method_1020(player.method_19538()).method_1029();
                class_243 v = this.method_19538().method_1020(player.method_19538()).method_1021(0.125);
                this.method_18799(vec.method_1020(v).method_1031(this.field_5974.method_43058() * 0.1, this.field_5974.method_43058() * 0.1, this.field_5974.method_43058() * 0.1));
                continue;
            }
            this.method_18800(0.0, 0.0, 0.0);
            return;
        }
        class_2338 blockPos = this.method_24515();
        class_2338 blockPos2 = blockPos.method_10084();
        boolean isTooHigh = true;
        for (int ix = 0; ix < 5 && (isTooHigh = this.method_37908().method_8320(blockPos.method_10087(ix)).method_26215()); ++ix) {
        }
        if (isTooHigh) {
            this.method_18800(this.method_18798().field_1352, -0.07, this.method_18798().field_1350);
        }
        if (!(this.hangingPosition == null || this.method_37908().method_22347(this.hangingPosition) && this.hangingPosition.method_10264() > this.method_37908().method_31607())) {
            this.hangingPosition = null;
        }
        if (this.hangingPosition == null || this.field_5974.method_43048(30) == 0 || this.hangingPosition.method_19769((class_2374)this.method_19538(), 2.0)) {
            this.hangingPosition = new class_2338((int)(this.method_23317() + (double)this.field_5974.method_43048(5) - 2.0), (int)(this.method_23318() + (double)this.field_5974.method_43048(5) - 2.5), (int)(this.method_23321() + (double)this.field_5974.method_43048(5) - 2.0));
        }
        double d = (double)this.hangingPosition.method_10263() + 0.1 - this.method_23317();
        double e = (double)this.hangingPosition.method_10264() + 0.1 - this.method_23318();
        double f = (double)this.hangingPosition.method_10260() + 0.1 - this.method_23321();
        class_243 vec3d = this.method_18798();
        class_243 vec3d2 = vec3d.method_1031((Math.signum(d) * 0.5 - vec3d.field_1352) * 0.01, (Math.signum(e) * 0.4 - vec3d.field_1351) * 0.01, (Math.signum(f) * 0.5 - vec3d.field_1350) * 0.01);
        this.method_18799(vec3d2);
        float g = (float)(class_3532.method_15349((double)vec3d2.field_1350, (double)vec3d2.field_1352) * 57.2957763671875) - 90.0f;
        float h = class_3532.method_15393((float)(g - this.method_36454()));
        this.field_6250 = 0.5f;
        this.method_36456(this.method_36454() + h);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public boolean method_5696() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return false;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(WISP_FLAGS, (Object)nbt.method_10571("WispFlags"));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10567("WispFlags", ((Byte)this.field_6011.method_12789(WISP_FLAGS)).byteValue());
    }

    public static boolean canSpawn(class_1299<class_1420> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (pos.method_10264() >= world.method_8615()) {
            return false;
        }
        int i = world.method_22339(pos);
        int j = 4;
        if (WispEntity.isTodayAroundHalloween()) {
            j = 7;
        } else if (random.method_43056()) {
            return false;
        }
        return i > random.method_43048(j) ? false : WispEntity.canMobSpawn(type, world, spawnReason, pos, random);
    }

    private static boolean isTodayAroundHalloween() {
        LocalDate localDate = LocalDate.now();
        int i = localDate.get(ChronoField.DAY_OF_MONTH);
        int j = localDate.get(ChronoField.MONTH_OF_YEAR);
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 / 2.0f;
    }
}

