/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg;

import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_7923;
import net.spell_engine.api.item.ItemConfig;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.tinyconfig.ConfigManager;
import net.witcher_rpg.blocks.WitcherBlocks;
import net.witcher_rpg.client.particle.Particles;
import net.witcher_rpg.config.Default;
import net.witcher_rpg.config.EffectsConfig;
import net.witcher_rpg.config.EnchantingConfig;
import net.witcher_rpg.custom.CustomSpells;
import net.witcher_rpg.custom.Enchantment_WitcherSpellSchool;
import net.witcher_rpg.custom.WitcherSchoolEnchanting;
import net.witcher_rpg.custom.WitcherSpellSchools;
import net.witcher_rpg.effect.Effects;
import net.witcher_rpg.entity.YrdenEntity;
import net.witcher_rpg.entity.YrdenMagicTrapEntity;
import net.witcher_rpg.item.WitcherGroup;
import net.witcher_rpg.item.WitcherItems;
import net.witcher_rpg.item.armor.Armors;
import net.witcher_rpg.item.weapon.WeaponsRegister;
import net.witcher_rpg.sounds.Sounds;
import net.witcher_rpg.util.loot.WitcherLootTableChestModifiers;
import net.witcher_rpg.worldgen.OreGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WitcherClassMod
implements ModInitializer {
    public static final String MOD_ID = "witcher_rpg";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"witcher_rpg");
    public static ConfigManager<ItemConfig> itemConfig = new ConfigManager("items_v5", (Object)Default.itemConfig).builder().setDirectory("witcher_rpg").sanitize(true).build();
    public static ConfigManager<EffectsConfig> effectsConfig = new ConfigManager("effects_v2", (Object)new EffectsConfig()).builder().setDirectory("witcher_rpg").sanitize(true).build();
    public static final ConfigManager<EnchantingConfig> enchantmentConfig = new ConfigManager("enchantments", (Object)new EnchantingConfig()).builder().setDirectory("witcher_rpg").sanitize(true).schemaVersion(4).build();

    private void registerItemGroup() {
        WitcherGroup.WITCHER = FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)WeaponsRegister.witcher_silver_sword.item())).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.witcher_rpg.general")).method_47324();
        class_2378.method_39197((class_2378)class_7923.field_44687, WitcherGroup.WITCHER_KEY, (Object)WitcherGroup.WITCHER);
    }

    public void onInitialize() {
        itemConfig.refresh();
        effectsConfig.refresh();
        enchantmentConfig.refresh();
        WitcherSpellSchools.initialize();
        WitcherLootTableChestModifiers.modifyChestLootTables();
        WitcherItems.registerModItems();
        Particles.register();
        Effects.register();
        WitcherGroup.registerItemGroups();
        OreGen.register();
        WitcherBlocks.register();
        CustomSpells.register();
        Sounds.register();
        WeaponsRegister.register(((ItemConfig)WitcherClassMod.itemConfig.value).weapons);
        Armors.register(((ItemConfig)WitcherClassMod.itemConfig.value).armor_sets);
        itemConfig.save();
        this.registerItemGroup();
        for (Map.Entry<class_2960, WitcherSchoolEnchanting> entry : Enchantment_WitcherSpellSchool.all.entrySet()) {
            class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)entry.getKey(), (Object)((Object)entry.getValue()));
        }
        this.attachEnchantmentsToSchools();
    }

    private void attachEnchantmentsToSchools() {
        for (SpellSchool school : SpellSchools.all()) {
            List<WitcherSchoolEnchanting> poweringEnchantments = Enchantment_WitcherSpellSchool.all.entrySet().stream().filter(entry -> ((WitcherSchoolEnchanting)((Object)((Object)entry.getValue()))).poweredSchools().contains(school)).map(Map.Entry::getValue).toList();
            school.addSource(SpellSchool.Trait.POWER, new SpellSchool.Source(SpellSchool.Apply.MULTIPLY, query -> {
                double value = 0.0;
                for (WitcherSchoolEnchanting enchantment : poweringEnchantments) {
                    int level = SpellPowerEnchanting.getEnchantmentLevel((class_1887)enchantment, (class_1309)query.entity(), null);
                    value = enchantment.amplified(value, level);
                }
                return value;
            }));
        }
    }

    static {
        YrdenEntity.ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "yrden"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, YrdenEntity::new).dimensions(class_4048.method_18384((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
        YrdenMagicTrapEntity.ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "yrden_magical_trap"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, YrdenMagicTrapEntity::new).dimensions(class_4048.method_18384((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
    }
}

