/*
 * Decompiled with CFR 0.152.
 */
package wraith.harvest_scythes;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2302;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wraith.harvest_scythes.api.scythe.HSScythesEvents;
import wraith.harvest_scythes.item.MacheteItem;
import wraith.harvest_scythes.registry.EnchantsRegistry;
import wraith.harvest_scythes.registry.ItemRegistry;
import wraith.harvest_scythes.support.DragonLootSupport;
import wraith.harvest_scythes.support.GobberSupport;
import wraith.harvest_scythes.support.HellishMaterialsSupport;
import wraith.harvest_scythes.support.MoreGemsSupport;
import wraith.harvest_scythes.support.MythicMetalsSupport;
import wraith.harvest_scythes.support.NaturesMineralsSupport;
import wraith.harvest_scythes.support.TechRebornSupport;
import wraith.harvest_scythes.support.WinterlySupport;
import wraith.harvest_scythes.util.Config;

public class HarvestScythes
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "harvest_scythes";
    private static boolean loaded = false;

    public static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        LOGGER.info("Loading [Harvest Scythes]");
        ItemRegistry.init();
        if (FabricLoader.getInstance().isModLoaded("mythicmetals")) {
            LOGGER.info("[Mythic Metals] detected. Loading supported items.");
            MythicMetalsSupport.loadItems();
        }
        if (FabricLoader.getInstance().isModLoaded("naturesminerals")) {
            LOGGER.info("[Nature's Minerals] detected. Loading supported items.");
            NaturesMineralsSupport.loadItems();
        }
        if (FabricLoader.getInstance().isModLoaded("more_gems")) {
            LOGGER.info("[More Gems] detected. Loading supported items.");
            MoreGemsSupport.loadItems();
        }
        if (FabricLoader.getInstance().isModLoaded("hellish-materials")) {
            LOGGER.info("[Hellish Materials] detected. Loading supported items.");
            HellishMaterialsSupport.loadItems();
        }
        if (FabricLoader.getInstance().isModLoaded("techreborn")) {
            LOGGER.info("[Tech Reborn] detected. Loading supported items.");
            TechRebornSupport.loadItems();
        }
        if (FabricLoader.getInstance().isModLoaded("dragonloot")) {
            LOGGER.info("[DragonLoot] detected. Loading supported items.");
            DragonLootSupport.loadItems();
        }
        if (FabricLoader.getInstance().isModLoaded("pigsteel")) {
            LOGGER.info("[PigSteel] detected. Loading supported recipes.");
        }
        if (FabricLoader.getInstance().isModLoaded("gobber2")) {
            LOGGER.info("[Gobber] detected. Loading supported items.");
            GobberSupport.loadItems();
        }
        if (FabricLoader.getInstance().isModLoaded("winterly")) {
            LOGGER.info("[Winterly] detected. Loading supported items.");
            WinterlySupport.loadItems();
        }
        EnchantsRegistry.registerEnchantments();
        LOGGER.info("[Harvest Scythes] has successfully been loaded!");
    }

    public void onInitialize() {
        this.registerEvents();
        Config.getInstance();
        HSScythesEvents.addSingleHarvestListener(event -> {
            class_2680 state = event.blockState();
            if (!(state.method_26204() instanceof class_2302) || class_1890.method_8225((class_1887)EnchantsRegistry.ENCHANTMENTS.get("blind_harvest_curse"), (class_1799)event.stack()) > 0) {
                return;
            }
            class_2498 sound = state.method_26231();
            event.world().method_8396(null, event.cropPos(), sound.method_10595(), class_3419.field_15245, sound.method_10597(), sound.method_10599());
        });
    }

    private void registerEvents() {
        PlayerBlockBreakEvents.AFTER.register(MacheteItem::tryHarvest);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(1))).executes(context -> {
            Config.getInstance().loadConfig();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"\u00a76[\u00a7eHarvest Scythes\u00a76] \u00a73has successfully reloaded!"), false);
            return 1;
        }))));
    }
}

