/*
 * Decompiled with CFR 0.152.
 */
package wraith.harvest_scythes.item;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import wraith.harvest_scythes.api.event.HarvestEvent;
import wraith.harvest_scythes.api.event.SingleHarvestEvent;
import wraith.harvest_scythes.api.machete.HSMacheteEvents;
import wraith.harvest_scythes.registry.EnchantsRegistry;
import wraith.harvest_scythes.registry.ItemRegistry;
import wraith.harvest_scythes.util.Config;
import wraith.harvest_scythes.util.HSUtils;

public class MacheteItem
extends class_1829 {
    protected int harvestDepth;

    public MacheteItem(class_1832 material, int attackDamage, float attackSpeed, int harvestDepth, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
        this.harvestDepth = harvestDepth;
    }

    public MacheteItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        this(material, attackDamage, attackSpeed, MacheteItem.getDepthFromMaterial(material), settings);
    }

    public MacheteItem(class_1832 material, class_1792.class_1793 settings) {
        this(material, 2, -2.0f, settings);
    }

    public MacheteItem(class_1832 material, int harvestDepth, class_1792.class_1793 settings) {
        this(material, 2, -2.0f, harvestDepth, settings);
    }

    private static int getDepthFromMaterial(class_1832 material) {
        return Math.min(10, material.method_8024() + 1) * 18;
    }

    public static int getHarvestDepth(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof MacheteItem)) {
            return 0;
        }
        MacheteItem machete = (MacheteItem)class_17922;
        int enchantLevel = class_1890.method_8225((class_1887)EnchantsRegistry.ENCHANTMENTS.get("leaf_eater"), (class_1799)stack);
        return class_3532.method_15340((int)(machete.getRegularHarvestDepth() + class_3532.method_15340((int)(enchantLevel * 18), (int)0, (int)240)), (int)0, (int)240);
    }

    public static void tryHarvest(class_1937 world, class_1657 player, class_2338 pos, class_2680 blockState, class_2586 blockEntity) {
        if (world.field_9236) {
            return;
        }
        class_1799 stack = player.method_6047();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof MacheteItem)) {
            return;
        }
        MacheteItem machete = (MacheteItem)class_17922;
        int blocksHarvested = 0;
        int damage = 0;
        boolean isCreative = machete == ItemRegistry.get("creative_machete");
        LinkedList<class_2338> positions = new LinkedList<class_2338>();
        positions.add(pos);
        while (!positions.isEmpty() && blocksHarvested <= MacheteItem.getHarvestDepth(stack)) {
            class_2338 curPos = (class_2338)positions.remove();
            class_2680 curState = world.method_8320(curPos);
            class_2248 block = curState.method_26204();
            if (!(block instanceof class_2397) && blocksHarvested > 0 || !Config.getInstance().canMacheteHarvest(class_7923.field_41175.method_10221((Object)block))) continue;
            world.method_22352(curPos, true);
            ++blocksHarvested;
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        positions.add(curPos.method_10069(x, y, z));
                    }
                }
            }
            boolean takeDamage = HSUtils.getRandomIntInRange(0, class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack)) == 0;
            HSMacheteEvents.onSingleHarvest(new SingleHarvestEvent(world, player, stack, curState, curPos, 1, blocksHarvested, takeDamage));
            if (isCreative || !takeDamage) continue;
            ++damage;
            stack.method_7956(1, (class_1309)player, p -> p.method_20235(class_1304.field_6173));
        }
        HSMacheteEvents.onHarvest(new HarvestEvent(world, player, stack, blocksHarvested, damage));
    }

    public int getRegularHarvestDepth() {
        return class_3532.method_15340((int)this.harvestDepth, (int)0, (int)240);
    }

    public boolean method_7856(class_2680 state) {
        return super.method_7856(state) || state.method_26204() instanceof class_2397;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return super.method_7885(state, world, pos, miner) || state.method_26204() instanceof class_2397;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43469((String)"harvest_scythes.machete_tooltip.depth", (Object[])new Object[]{class_2561.method_43471((String)"harvest_scythes.machete_tooltip.depth.arg_color").method_27693(String.valueOf(MacheteItem.getHarvestDepth(stack)))}));
    }
}

