/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3414;

public class SoundProfileEntry {
    private String soundName;
    private List<Integer> listSoundEventTypes = new ArrayList<Integer>();
    private boolean isSoundType;
    private double multiplier;
    private double maxDistToSpawnFromPlayer = 4.0;
    private boolean partialMatchOnly = false;
    private int oddsTo1ToUse = 0;

    public static String getSoundEventName(class_3414 soundEvent) {
        return soundEvent.method_14833().toString();
    }

    public SoundProfileEntry(class_3414 soundEvent, double multiplier) {
        this(SoundProfileEntry.getSoundEventName(soundEvent), multiplier, false, 0);
    }

    public SoundProfileEntry(class_3414 soundEvent, double multiplier, int oddsTo1ToUse) {
        this(SoundProfileEntry.getSoundEventName(soundEvent), multiplier, false, oddsTo1ToUse);
    }

    public SoundProfileEntry(String soundName, double multiplier) {
        this(soundName, multiplier, true, 0);
    }

    public SoundProfileEntry(String soundName, double multiplier, boolean partialMatchOnly, int oddsTo1ToUse) {
        this.soundName = soundName;
        this.multiplier = multiplier;
        this.partialMatchOnly = partialMatchOnly;
        this.oddsTo1ToUse = oddsTo1ToUse;
    }

    public String getSoundName() {
        return this.soundName;
    }

    public void setSoundName(String soundName) {
        this.soundName = soundName;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public double getMaxDistToSpawnFromPlayer() {
        return this.maxDistToSpawnFromPlayer;
    }

    public SoundProfileEntry setMaxDistToSpawnFromPlayer(double maxDistToSpawnFromPlayer) {
        this.maxDistToSpawnFromPlayer = maxDistToSpawnFromPlayer;
        return this;
    }

    public boolean isPartialMatchOnly() {
        return this.partialMatchOnly;
    }

    public void setPartialMatchOnly(boolean partialMatchOnly) {
        this.partialMatchOnly = partialMatchOnly;
    }

    public int getOddsTo1ToUse() {
        return this.oddsTo1ToUse;
    }

    public void setOddsTo1ToUse(int oddsTo1ToUse) {
        this.oddsTo1ToUse = oddsTo1ToUse;
    }

    public boolean containsSoundType(int soundType) {
        return this.listSoundEventTypes.contains(soundType);
    }

    public List<Integer> getListSoundEventTypes() {
        return this.listSoundEventTypes;
    }

    public SoundProfileEntry setListSoundEventTypes(List<Integer> listSoundEventTypes) {
        this.listSoundEventTypes = listSoundEventTypes;
        this.isSoundType = true;
        return this;
    }

    public boolean isSoundType() {
        return this.isSoundType;
    }

    public void setSoundType(boolean soundType) {
        this.isSoundType = soundType;
    }
}

