/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap;

import com.gtnewhorizons.retrofuturabootstrap.RfbSystemClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.SharedConfig;
import com.gtnewhorizons.retrofuturabootstrap.URLClassLoaderBase;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformerHandle;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Main {
    @Nullable
    public static RfbSystemClassLoader compatLoader;
    @Nullable
    public static ExtensibleClassLoader launchLoader;
    @NotNull
    private static final @NotNull AtomicReference<@NotNull RfbClassTransformerHandle[]> rfbTransformers;
    @NotNull
    public static final ClassLoader appClassLoader;
    @NotNull
    public static final String RFB_CLASS_DUMP_PREFIX = "RFB_CLASS_DUMP";
    public static final boolean cfgDumpLoadedClasses;
    public static final boolean cfgDumpLoadedClassesPerTransformer;
    public static final boolean cfgDumpClassesAsynchronously;
    public static @NotNull AtomicReference<@Nullable Path> classDumpDirectory;
    @Nullable
    public static String initialGameVersion;
    @Nullable
    public static File initialGameDir;
    @Nullable
    public static File initialAssetsDir;
    @NotNull
    public static Logger logger;
    @NotNull
    public static final String JAVA_VERSION;
    public static final int JAVA_MAJOR_VERSION;
    @Nullable
    private static final ExecutorService classDumpingService;

    @NotNull
    public static String rfbVersion() {
        return "1.0.9.dirty";
    }

    @NotNull
    public static @NotNull URL @NotNull [] getUrlClasspathEntries() {
        return RfbSystemClassLoader.getUrlClasspathEntries(appClassLoader);
    }

    public static void addClasspathUrl(@NotNull URL url) {
        if (compatLoader != null) {
            compatLoader.addURL(url);
        }
        if (launchLoader != null) {
            launchLoader.addURL(url);
        }
    }

    public static void addSilentClasspathUrl(@NotNull URL url) {
        if (compatLoader != null) {
            compatLoader.addSilentURL(url);
        }
        if (launchLoader != null) {
            launchLoader.addSilentURL(url);
        }
    }

    @NotNull
    public static @NotNull List<@NotNull RfbClassTransformerHandle> getRfbTransformers() {
        return SharedConfig.getRfbTransformers();
    }

    public static void mutateRfbTransformers(@NotNull @NotNull Consumer<@NotNull List<@NotNull RfbClassTransformerHandle>> mutator) {
        ArrayList<RfbClassTransformerHandle> mutable;
        RfbClassTransformerHandle[] modified;
        RfbClassTransformerHandle[] original;
        do {
            original = rfbTransformers.get();
            mutable = new ArrayList<RfbClassTransformerHandle>(Arrays.asList(original));
            mutator.accept(mutable);
        } while (!rfbTransformers.compareAndSet(original, modified = mutable.toArray(new RfbClassTransformerHandle[0])));
    }

    public static void main(String[] args) throws Throwable {
        String[] combinedArgs;
        block16: {
            SharedConfig.classDumpingService = classDumpingService;
            SharedConfig.warnLogHandler = (msg, throwable) -> logger.warn("{}", new Object[]{msg, throwable});
            SharedConfig.debugLogHandler = (msg, throwable) -> logger.debug("{}", new Object[]{msg, throwable});
            boolean doClassLoaderCheck = !Boolean.getBoolean("rfb.skipClassLoaderCheck");
            boolean systemLoaderIsRfb = ClassLoader.getSystemClassLoader() instanceof RfbSystemClassLoader;
            if (doClassLoaderCheck && !systemLoaderIsRfb) {
                throw new IllegalStateException("System classloader not overwritten, add -Djava.system.class.loader=com.gtnewhorizons.retrofuturabootstrap.RfbSystemClassLoader to your JVM flags");
            }
            if (systemLoaderIsRfb) {
                compatLoader = (RfbSystemClassLoader)ClassLoader.getSystemClassLoader();
            } else {
                compatLoader = new RfbSystemClassLoader(ClassLoader.getSystemClassLoader());
                Thread.currentThread().setContextClassLoader(compatLoader);
            }
            if (JAVA_MAJOR_VERSION > 8 && URLClassLoaderBase.implementationVersion() == 8) {
                throw new IllegalStateException("Java newer than 8 is used, while the URLClassLoaderBase for Java 8 was loaded by " + URLClassLoaderBase.class.getClassLoader().getClass().getName());
            }
            if (classDumpingService != null) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    classDumpingService.shutdown();
                    if (!classDumpingService.isTerminated()) {
                        logger.info("Waiting for final class dumps to finish...");
                        try {
                            if (!classDumpingService.awaitTermination(10L, TimeUnit.SECONDS)) {
                                logger.warn("Classes did not finish dumping in 10 seconds, aborting.");
                                classDumpingService.shutdownNow();
                            }
                        }
                        catch (InterruptedException e) {
                            logger.warn("Classes did not finish dumping in 10 seconds, aborting.");
                            classDumpingService.shutdownNow();
                        }
                    }
                }, "RFB ClassDumpingService Shutdown hook"));
            }
            URL mainLocation = Main.class.getProtectionDomain().getCodeSource().getLocation();
            while ("jar".equalsIgnoreCase(mainLocation.getProtocol())) {
                String str = mainLocation.toString();
                mainLocation = new URL(str.substring(4, str.lastIndexOf(33)));
            }
            combinedArgs = args;
            try {
                Path mainFile = Paths.get(mainLocation.toURI());
                if (!mainFile.toString().toLowerCase(Locale.ROOT).endsWith(".jar")) break block16;
                try (JarFile mainJar = new JarFile(mainFile.toFile());){
                    String extraArgsCombined;
                    Manifest mainMf = mainJar.getManifest();
                    if (mainMf != null && (extraArgsCombined = mainMf.getMainAttributes().getValue("Rfb-Extra-Main-Args")) != null) {
                        String[] extraArgs = extraArgsCombined.split("\t");
                        combinedArgs = Arrays.copyOf(args, args.length + extraArgs.length);
                        System.arraycopy(extraArgs, 0, combinedArgs, args.length, combinedArgs.length);
                    }
                }
            }
            catch (IOException mainFile) {
                // empty catch block
            }
        }
        try {
            Class<?> launchClass = Class.forName("net.minecraft.launchwrapper.Launch", true, compatLoader);
            Method main = launchClass.getMethod("main", String[].class);
            main.invoke(null, new Object[]{combinedArgs});
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    public static void dumpClass(String classLoaderName, String className, byte[] classBytes) {
        SharedConfig.dumpClass(classLoaderName, className, classBytes);
    }

    static {
        rfbTransformers = SharedConfig.rfbTransformers;
        appClassLoader = Main.class.getClassLoader();
        cfgDumpLoadedClasses = SharedConfig.cfgDumpLoadedClasses;
        cfgDumpLoadedClassesPerTransformer = SharedConfig.cfgDumpLoadedClassesPerTransformer;
        cfgDumpClassesAsynchronously = SharedConfig.cfgDumpClassesAsynchronously;
        classDumpDirectory = SharedConfig.classDumpDirectory;
        logger = LogManager.getLogger((String)"LaunchWrapper");
        JAVA_VERSION = URLClassLoaderBase.getJavaVersion();
        JAVA_MAJOR_VERSION = URLClassLoaderBase.getJavaMajorVersion();
        classDumpingService = cfgDumpClassesAsynchronously ? Executors.newFixedThreadPool(Math.min(4, Runtime.getRuntime().availableProcessors()), runnable -> {
            Thread t = new Thread(runnable);
            t.setName("RFB Class Dumping Executor");
            t.setDaemon(true);
            return t;
        }) : null;
    }
}

